/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs.rpa.helper;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.cs.ChatInfoEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChatInfoHelper {
    private static final int MESSAGE_FROM_USER = 1;
    private static final int MESSAGE_FROM_AGENT_OR_BOT = 2;
    private static final int CUSTOMER_TYPE_AGENT = 0;
    private static final int CUSTOMER_TYPE_BOT = 1;
    private static final int CUSTOMER_TYPE_AUTOMATION = 2;
    private static String assigneeInfo;

    private static List<ChatInfoEntity> getListForLoginAndPoll(String jsonString) {
        ArrayList<ChatInfoEntity> chatInfoList = new ArrayList<ChatInfoEntity>();
        Pattern pattern = Pattern.compile("[0-9]*");
        JSONObject loginMsgObject = JsonHelper.getJsonObject(jsonString);
        Iterator keys = loginMsgObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("assigneeinfo".equals(key)) {
                assigneeInfo = loginMsgObject.optString("assigneeinfo");
                continue;
            }
            if (CustomConfig.CustomerService.isMessageTimestampVisible && "chatTimestamp".equals(key)) {
                ChatInfoHelper.prepareTimeStampMessageForLogin(chatInfoList, loginMsgObject.optString("chatTimestamp"));
                continue;
            }
            String[] chatKey = key.split("\\|");
            if (!pattern.matcher(chatKey[0]).matches()) continue;
            ChatInfoEntity entity = new ChatInfoEntity();
            entity.setTimeStamp(Long.parseLong(chatKey[0]));
            if (chatKey.length == 2) {
                String agentName = chatKey[1];
                entity.setRole("Bot".equals(agentName) ? 3 : 4);
                entity.setAgentName(agentName);
            } else {
                entity.setRole(2);
                entity.setAgentName("");
            }
            String message = loginMsgObject.optString(ChatInfoHelper.getConversationJSONObjectKey(entity));
            entity.setMessage(message);
            JSONObject messageJson = JsonHelper.getJsonObject(message);
            entity.setMsgType(JsonHelper.opt(messageJson, "type", -1));
            chatInfoList.add(entity);
        }
        Collections.sort(chatInfoList);
        return chatInfoList;
    }

    public static void prepareTimeStampMessageForLogin(ArrayList<ChatInfoEntity> chatInfoList, String chatTimeStamp) {
        String[] timeStampArray;
        if (TextUtils.isEmpty((CharSequence)chatTimeStamp)) {
            return;
        }
        for (String timeStamp : timeStampArray = chatTimeStamp.split(",")) {
            if (!Pattern.compile("[0-9]*").matcher(timeStamp).matches()) continue;
            ChatInfoEntity entity = new ChatInfoEntity();
            entity.setRole(1);
            entity.setTimeStamp(Long.parseLong(timeStamp) - 1L);
            chatInfoList.add(entity);
        }
    }

    public static void prepareNickname(ChatInfoEntity entity) {
        block4: {
            if (!TextUtils.isEmpty((CharSequence)assigneeInfo)) {
                try {
                    JSONArray jsonArray = new JSONArray(assigneeInfo);
                    if (jsonArray.length() <= 0) break block4;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        int userId = jsonObject.optInt("userid");
                        String userName = jsonObject.optString("username");
                        if (entity.getUserId() != userId && !userName.equals(entity.getAgentName())) continue;
                        String nickname = JsonHelper.optString(jsonObject, "nickname");
                        entity.setAgentNickname(nickname);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getConversationJSONObjectKey(ChatInfoEntity infoEntity) {
        String key = String.valueOf(infoEntity.getTimeStamp());
        if (!TextUtils.isEmpty((CharSequence)infoEntity.getAgentName())) {
            key = key + "|" + infoEntity.getAgentName();
        }
        return key;
    }

    private static List<ChatInfoEntity> getListForRefresh(String jsonString) {
        ArrayList<ChatInfoEntity> chatInfoList = new ArrayList<ChatInfoEntity>();
        JSONArray jsonArray = JsonHelper.getJsonArray(jsonString);
        for (int i = 0; i < jsonArray.length(); ++i) {
            ChatInfoEntity entity;
            JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
            if (jsonObject.optBoolean("isWithdraw")) continue;
            if (jsonObject.optBoolean("isShowTimeLine")) {
                entity = new ChatInfoEntity();
                entity.setRole(1);
                entity.setTimeStamp(jsonObject.optLong("messageTime", 0L) - 1L);
                chatInfoList.add(entity);
            }
            entity = new ChatInfoEntity();
            entity.setTimeStamp(jsonObject.optLong("messageTime", 0L));
            entity.setAgentNickname(JsonHelper.optString(jsonObject, "customer"));
            entity.setUserId(jsonObject.optInt("customerId", 0));
            entity.setMsgType(JsonHelper.opt(jsonObject, "messageType", -1));
            entity.setMessage(ChatInfoHelper.getMessageString(jsonObject));
            entity.setRole(ChatInfoHelper.getRole(jsonObject));
            chatInfoList.add(entity);
        }
        Collections.sort(chatInfoList);
        return chatInfoList;
    }

    private static String getMessageString(JSONObject jsonObject) {
        JSONObject messageObject = new JSONObject();
        try {
            messageObject.put("content", (Object)JsonHelper.optString(jsonObject, "message"));
            messageObject.put("type", (Object)JsonHelper.opt(jsonObject, "messageType", -1));
            messageObject.put("feedback", jsonObject.optInt("feedback"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return messageObject.toString();
    }

    private static int getRole(JSONObject jsonObject) {
        switch (jsonObject.optInt("messageFrom")) {
            case 1: {
                return 2;
            }
            case 2: {
                switch (jsonObject.optInt("customerType")) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 5;
                    }
                }
            }
        }
        return 1;
    }

    public static List<ChatInfoEntity> getChatInfoList(String jsonString, int historyType) {
        switch (historyType) {
            case 1: 
            case 3: {
                return ChatInfoHelper.getListForLoginAndPoll(jsonString);
            }
            case 2: {
                return ChatInfoHelper.getListForRefresh(jsonString);
            }
        }
        return new ArrayList<ChatInfoEntity>();
    }
}

