/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs.rpa.helper;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.logic.cs.rpa.factory.AgentMessageFactory;
import net.aihelp.data.logic.cs.rpa.factory.BotMessageFactory;
import net.aihelp.data.logic.cs.rpa.factory.TimeMessageFactory;
import net.aihelp.data.logic.cs.rpa.factory.UserMessageFactory;
import net.aihelp.data.logic.cs.rpa.helper.ChatInfoHelper;
import net.aihelp.data.model.cs.ChatInfoEntity;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import org.json.JSONObject;

public class HistoryHelper {
    public static final int HISTORY_TYPE_LOGIN = 1;
    public static final int HISTORY_TYPE_REFRESH = 2;
    public static final int HISTORY_TYPE_POLL = 3;

    private static List<Message> getListFromMsgString(ChatInfoEntity chatInfoEntity, int historyType) {
        int role = chatInfoEntity.getRole();
        long timeStamp = chatInfoEntity.getTimeStamp();
        String msg = chatInfoEntity.getMessage();
        int msgType = chatInfoEntity.getMsgType();
        ArrayList<Message> messageList = new ArrayList<Message>();
        switch (role) {
            case 1: {
                if (historyType == 3) break;
                messageList.add(TimeMessageFactory.getTimeMessage(timeStamp));
                break;
            }
            case 4: 
            case 5: {
                ChatInfoHelper.prepareNickname(chatInfoEntity);
                messageList.add(AgentMessageFactory.getAgentMessage(msg, timeStamp, chatInfoEntity.getAgentNickname()));
                break;
            }
            case 3: {
                JSONObject msgJsonObject = JsonHelper.getJsonObject(msg);
                if (JsonHelper.hasKey(msgJsonObject, "customerId")) {
                    chatInfoEntity.setUserId(msgJsonObject.optInt("customerId"));
                }
                ChatInfoHelper.prepareNickname(chatInfoEntity);
                BotMessage botMessage = BotMessageFactory.getHistoricBotMessage(msg, timeStamp, chatInfoEntity.getAgentNickname(), historyType);
                if (botMessage.hasSelfService() && botMessage.getSelfService().isEnableSend()) {
                    return messageList;
                }
                messageList.add(botMessage);
                break;
            }
            default: {
                messageList.addAll(UserMessageFactory.getUserMessage(msgType, msg, timeStamp));
            }
        }
        return messageList;
    }

    public static List<Message> getHistoryList(String msgJson, int historyType) {
        ArrayList<Message> list = new ArrayList<Message>();
        if (!TextUtils.isEmpty((CharSequence)msgJson)) {
            for (ChatInfoEntity chatInfoEntity : ChatInfoHelper.getChatInfoList(msgJson, historyType)) {
                list.addAll(HistoryHelper.getListFromMsgString(chatInfoEntity, historyType));
            }
        }
        return list;
    }
}

