/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg;

import android.text.TextUtils;
import java.util.List;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Answer;
import net.aihelp.data.model.rpa.msg.bot.ExternalUrl;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.model.rpa.msg.bot.FormUrl;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.utils.ListUtil;

public class BotMessage
extends Message {
    public static final int USER_FEEDBACK_INVISIBLE = -1;
    public static final int USER_FEEDBACK_NONE = 0;
    public static final int USER_FEEDBACK_POSITIVE = 1;
    public static final int USER_FEEDBACK_NEGATIVE = 2;
    private FormUrl formUrl;
    private ExternalUrl externalUrl;
    private Faq faq;
    private SelfService selfService;
    private List<Answer> botAnswers;
    private int userFeedback;

    public BotMessage(String nickname) {
        this.setNickname(nickname);
    }

    public FormUrl getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(FormUrl formUrl) {
        this.formUrl = formUrl;
    }

    public ExternalUrl getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(ExternalUrl externalUrl) {
        this.externalUrl = externalUrl;
    }

    public Faq getFaq() {
        return this.faq;
    }

    public void setFaq(Faq faq) {
        this.faq = faq;
        if (this.hasFaq()) {
            this.setMsgType(4);
        }
    }

    public SelfService getSelfService() {
        return this.selfService;
    }

    public void setSelfService(SelfService selfService) {
        this.selfService = selfService;
        if (this.hasSelfService() && selfService.isEnableSend()) {
            this.setNormalMessage(false);
        }
    }

    public List<Answer> getBotAnswers() {
        return this.botAnswers;
    }

    public void setBotAnswers(List<Answer> botAnswers) {
        this.botAnswers = botAnswers;
        if (this.hasBotAnswers()) {
            this.setMsgType(5);
        }
    }

    public int getUserFeedback() {
        return this.userFeedback;
    }

    public void setUserFeedback(int userFeedback) {
        this.userFeedback = userFeedback;
    }

    @Override
    public void setContent(String content) {
        super.setContent(content);
        this.setMsgType(3);
    }

    public boolean hasFormUrl() {
        return this.formUrl != null && !TextUtils.isEmpty((CharSequence)this.formUrl.getLink()) && !TextUtils.isEmpty((CharSequence)this.formUrl.getTitle());
    }

    public boolean hasExternalUrl() {
        return this.externalUrl != null && !TextUtils.isEmpty((CharSequence)this.externalUrl.getLink()) && !TextUtils.isEmpty((CharSequence)this.externalUrl.getTitle());
    }

    public boolean hasFaq() {
        return this.faq != null && !ListUtil.isListEmpty(this.faq.getFaqDataList());
    }

    public boolean hasSelfService() {
        return this.selfService != null && !TextUtils.isEmpty((CharSequence)this.selfService.getSelfServiceData()) && !"[]".equals(this.selfService.getSelfServiceData());
    }

    public boolean hasBotAnswers() {
        return !ListUtil.isListEmpty(this.botAnswers);
    }
}

