/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg;

import android.webkit.MimeTypeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.data.model.rpa.msg.base.Message;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserMessage
extends Message {
    public static final int INPUT_FORMAT_TEXT = 1;
    public static final int INPUT_FORMAT_BUTTON = 2;
    public static final int INPUT_FORMAT_DATE = 3;
    public static final int INPUT_FORMAT_ATTACHMENT = 4;
    public static final int INPUT_FORMAT_INTENT = 5;
    public static final int INPUT_SOURCE_INPUT = 1;
    public static final int INPUT_SOURCE_ACTION = 2;
    public static final int INPUT_SOURCE_DATE = 3;
    public static final int INPUT_SOURCE_SELF_SERVICE = 4;
    public static final int INPUT_SOURCE_RPA_FAQ = 5;
    public static final int INPUT_SOURCE_ANSWER_BOT = 6;
    public static final int INPUT_SOURCE_SKIP = 7;
    public static final int INPUT_SOURCE_INTENT = 8;
    public static final int INPUT_SOURCE_PREDICT = 9;
    private int evaluateGrade;

    public int getEvaluateGrade() {
        return this.evaluateGrade;
    }

    public void setEvaluateGrade(int evaluateGrade) {
        this.evaluateGrade = evaluateGrade;
    }

    @Override
    public void setContent(String content) {
        Matcher imageMatcher = Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(content);
        Matcher videoMatcher = Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(content);
        if (!imageMatcher.matches() && !videoMatcher.matches()) {
            String textMsg = content;
            while (imageMatcher.find()) {
                textMsg = textMsg.replace(imageMatcher.group(), "");
            }
            Matcher newVideoMatcher = Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(textMsg);
            while (newVideoMatcher.find()) {
                textMsg = textMsg.replace(newVideoMatcher.group(), "");
            }
            super.setContent(textMsg.replace(";", ""));
            this.setMsgType(10);
        }
        this.setMsgStatus(1);
    }

    public void setRequestParams(String input, int inputFormat, int inputSource) {
        super.setRequestParams(UserMessage.getRequestParams(input, inputFormat, inputSource));
    }

    public void setRequestParams(String input, boolean skip, int inputFormat, String inputData, int inputSource) {
        super.setRequestParams(UserMessage.getRequestParams(input, skip, inputFormat, inputData, inputSource));
    }

    public static JSONObject getRequestParams(String input, int inputFormat, int inputSource) {
        return UserMessage.getRequestParams(input, false, inputFormat, "", inputSource);
    }

    public static JSONObject getRequestParams(String input, boolean skip, int inputFormat, String inputData, int inputSource) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", (Object)input);
            jsonObject.put("skip", skip);
            jsonObject.put("inputFormat", inputFormat);
            jsonObject.put("inputData", (Object)inputData);
            jsonObject.put("inputSource", inputSource);
            jsonObject.put("eventId", (Object)UUID.randomUUID().toString().replace("-", ""));
            return jsonObject;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static JSONObject getRequestParams(String url, String fileName, long fileSize, float width, float height) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", (Object)"");
            jsonObject.put("skip", false);
            jsonObject.put("inputFormat", 4);
            jsonObject.put("inputData", (Object)"");
            jsonObject.put("eventId", (Object)UUID.randomUUID().toString().replace("-", ""));
            JSONArray attachmentList = new JSONArray();
            JSONObject attachmentItem = new JSONObject();
            attachmentItem.put("url", (Object)url);
            attachmentItem.put("filename", (Object)fileName);
            attachmentItem.put("size", fileSize);
            attachmentItem.put("width", (double)width);
            attachmentItem.put("height", (double)height);
            attachmentItem.put("type", (Object)MimeTypeMap.getFileExtensionFromUrl((String)url));
            attachmentList.put((Object)attachmentItem);
            jsonObject.put("attachments", (Object)attachmentList);
            return jsonObject;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }
}

