/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.msg.agent;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.logic.cs.rpa.factory.MessageFactory;
import net.aihelp.data.model.rpa.msg.agent.AgentMessage;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.utils.RegexUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class AgentRichMessage
extends Message {
    private List<Message> messageList;

    public AgentRichMessage(String nickname) {
        this.setNickname(nickname);
        this.setMsgType(8);
    }

    public void setMessageList(String message) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        String content = MessageFactory.getPeeledContent(message);
        LinkedList<Integer> urlIndexList = new LinkedList<Integer>();
        urlIndexList.add(0);
        Matcher formMatcher = Pattern.compile("(?i)(https?://\\S*?((?=\\s+http)|\\.(png|jpg|jpeg|gif|mp4|3gp|mkv|webm))|https?://((?!\").)*)").matcher(content);
        while (formMatcher.find()) {
            urlIndexList.add(formMatcher.start());
            urlIndexList.add(formMatcher.end());
        }
        if (((Integer)urlIndexList.getLast()).intValue() != content.length()) {
            urlIndexList.add(content.length());
        }
        for (int i = 0; i < urlIndexList.size() - 1; ++i) {
            String urlOrRawText = content.substring((Integer)urlIndexList.get(i), (Integer)urlIndexList.get(i + 1)).trim();
            if (Pattern.compile("\\s*?").matcher(urlOrRawText).matches()) continue;
            if (Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(urlOrRawText).matches()) {
                arrayList.add(new FileMessage(6, urlOrRawText));
                continue;
            }
            if (Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(urlOrRawText).matches()) {
                arrayList.add(new FileMessage(7, urlOrRawText));
                continue;
            }
            AgentMessage textMessage = new AgentMessage(3);
            textMessage.setContent(urlOrRawText);
            arrayList.add(textMessage);
        }
        JSONObject contentObject = MessageFactory.getContentObject(JsonHelper.getJsonObject(message));
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        for (int i = 0; i < attachments.length(); ++i) {
            JSONObject attachItem = JsonHelper.getJsonObject(attachments, i);
            String fileUrl = JsonHelper.optString(attachItem, "url");
            String fileName = JsonHelper.optString(attachItem, "filename");
            int fileSize = attachItem.optInt("size", 0);
            int msgType = 9;
            if (RegexUtil.isImageFile(fileUrl)) {
                msgType = 6;
            } else if (RegexUtil.isVideoFile(fileUrl)) {
                msgType = 7;
            }
            FileMessage fileMessage = new FileMessage(msgType, fileUrl);
            fileMessage.setFileInfo(fileName, fileSize);
            fileMessage.setNormalMessage(true);
            arrayList.add(fileMessage);
        }
        this.messageList = arrayList;
    }

    public List<Message> getMessageList() {
        return this.messageList;
    }
}

