/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.rpa.step;

import android.util.SparseArray;
import java.util.List;
import net.aihelp.core.net.json.JsonHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class RPAStep {
    public static final int STEP_BOT_INPUT_TEXT = 1;
    public static final int STEP_BOT_INPUT_MAIL = 2;
    public static final int STEP_BOT_INPUT_NUMBER = 3;
    public static final int STEP_ACTION_PICKER = 4;
    public static final int STEP_DATE_PICKER = 5;
    public static final int STEP_ADDING_ATTACHMENT = 6;
    public static final int STEP_FILLING_FORM = 7;
    public static final int STEP_SELF_SERVICE = 8;
    public static final int STEP_EVALUATE_FAQ = 9;
    public static final int STEP_RESOLVE_CONFIRM = 10;
    public static final int STEP_EVALUATE_SERVICE = 11;
    public static final int STEP_MANUAL_INPUT = 100;
    public static final int STEP_NEW_CONVERSATION = 102;
    public static final int STEP_STOP_AND_WAIT = 103;
    public static final int STEP_RE_LOGIN = 104;
    public static final int STEP_IGNORE_THIS = 105;
    private boolean enablePrevStep;
    private boolean enableSkip;
    private boolean enableUpload;
    private boolean enableActionInput;
    private int nextStep = 1;
    private String stepId;
    private List<Action> actionList;
    private String prevStepHint;
    private String skipHint;
    private String formButtonHint;
    private String attachmentTypes;
    private boolean optionRequired;
    private int maxOptionCount;
    private SparseArray<JSONArray> opinionArray;

    public boolean isEnablePrevStep() {
        return this.enablePrevStep;
    }

    public void setEnablePrevStep(boolean enablePrevStep) {
        this.enablePrevStep = enablePrevStep;
    }

    public String getPrevStepHint() {
        return this.prevStepHint;
    }

    public void setPrevStepHint(String prevStepHint) {
        this.prevStepHint = prevStepHint;
    }

    public String getFormButtonHint() {
        return this.formButtonHint;
    }

    public void setFormButtonHint(String formButtonHint) {
        this.formButtonHint = formButtonHint;
    }

    public String getSkipHint() {
        return this.skipHint;
    }

    public void setSkipHint(String skipHint) {
        this.skipHint = skipHint;
    }

    public boolean isEnableSkip() {
        return this.enableSkip;
    }

    public void setEnableSkip(boolean enableSkip) {
        this.enableSkip = enableSkip;
    }

    public boolean isEnableUpload() {
        return this.enableUpload;
    }

    public void setEnableUpload(boolean enableUpload) {
        this.enableUpload = enableUpload;
    }

    public boolean isEnableActionInput() {
        return this.enableActionInput;
    }

    public void setEnableActionInput(boolean enableActionInput) {
        this.enableActionInput = enableActionInput;
    }

    public int getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(int nextStep) {
        this.nextStep = nextStep;
    }

    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public List<Action> getActionList() {
        return this.actionList;
    }

    public void setActionList(List<Action> actionList) {
        this.actionList = actionList;
    }

    public String getAttachmentTypes() {
        return this.attachmentTypes;
    }

    public void setAttachmentTypes(String jsonString) {
        JSONObject object = JsonHelper.getJsonObject(jsonString);
        String imageTypes = JsonHelper.optString(object, "imageTypes");
        String videoTypes = JsonHelper.optString(object, "videoTypes");
        String fileTypes = JsonHelper.optString(object, "fileTypes");
        this.attachmentTypes = String.format("%s,%s,%s", imageTypes, videoTypes, fileTypes);
        this.attachmentTypes = this.attachmentTypes.replaceAll("\\.", "");
    }

    public boolean isOptionRequired() {
        return this.optionRequired;
    }

    public void setOptionRequired(boolean optionRequired) {
        this.optionRequired = optionRequired;
    }

    public int getMaxOptionCount() {
        return this.maxOptionCount;
    }

    public void setMaxOptionCount(int maxOptionCount) {
        this.maxOptionCount = maxOptionCount;
    }

    public SparseArray<JSONArray> getOpinionArray() {
        return this.opinionArray;
    }

    public void setOpinionArray(SparseArray<JSONArray> opinionArray) {
        this.opinionArray = opinionArray;
    }

    public static class Action
    implements Comparable<Action> {
        private int order;
        private String id;
        private String content;

        public static Action getInstance(int order, String actionId, String actionContent) {
            Action action = new Action();
            action.setOrder(order);
            action.setId(actionId);
            action.setContent(actionContent);
            return action;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public int compareTo(Action o) {
            return this.order - o.getOrder();
        }
    }
}

