/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.event;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.track.event.utils.EventHelper;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.utils.ClipboardUtil;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.RegexUtil;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.UploadFileHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public enum EventTracker {
    INSTANCE;

    public static long SAMPLING_LOG_SIZE_LIMIT;
    public static String SAMPLING_LOG_VERSION;
    private boolean isTargeted = false;
    private JSONArray targetUserIds = new JSONArray();
    private String matchingRegex = "";

    public void log(int type, Object ... extraData) {
        if (this.isTargeted) {
            // empty if block
        }
    }

    public void syncTrackMessage() {
        this.isTargeted = false;
        final Context context = AIHelpContext.getInstance().getContext();
        String filePath = EventHelper.INSTANCE.getFilePath(context);
        String filename = String.format("%s.txt", DeviceUuidFactory.id(context));
        File originFile = new File(filePath);
        if (originFile.exists() && originFile.length() > 0L) {
            final File file = FileUtil.copyAndRenameFile(context, filePath, filename);
            if (file != null && file.exists() && file.length() > 0L) {
                originFile.delete();
                this.makeToast(context, "Uploading log, please be patient...");
                UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener(){

                    @Override
                    public void onFileUploaded(String fileUrl) {
                        file.delete();
                        if (BreakReleaseHelper.isBreak()) {
                            ClipboardUtil.copy(context, fileUrl);
                        }
                    }
                }).performUpload(file);
            }
        } else {
            this.makeToast(context, "No logs are found.");
        }
    }

    public void prepareDataSource() {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(100));
            JSONObject jsonObject = JsonHelper.getJsonObject(content);
            this.targetUserIds = JsonHelper.getJsonArray(jsonObject, "userIds");
            this.matchingRegex = JsonHelper.optString(jsonObject, "wildcardSamplingUserId");
            SAMPLING_LOG_VERSION = JsonHelper.optString(jsonObject, "version");
            SAMPLING_LOG_SIZE_LIMIT = JsonHelper.opt(jsonObject, "maxSize", SAMPLING_LOG_SIZE_LIMIT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTargetedStatus();
    }

    public void updateTargetedStatus() {
        block6: {
            if (this.isTargeted) {
                return;
            }
            try {
                if (BreakReleaseHelper.isBreak()) {
                    this.markTargetedAndStartingPoint();
                    return;
                }
                if (RegexUtil.isRegexValid(this.matchingRegex) && Pattern.matches(this.matchingRegex, UserProfile.USER_ID)) {
                    this.markTargetedAndStartingPoint();
                    return;
                }
                if (this.targetUserIds == null) break block6;
                for (int i = 0; i < this.targetUserIds.length(); ++i) {
                    String sample = this.targetUserIds.optString(i, "").toLowerCase();
                    if (!TextUtils.equals((CharSequence)sample, (CharSequence)HttpConfig.md5(UserProfile.USER_ID).toLowerCase())) continue;
                    this.markTargetedAndStartingPoint();
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void makeToast(Context context, String toast) {
        if (BreakReleaseHelper.isBreak()) {
            ToastUtil.INSTANCE.makeRawToast(context, toast);
        }
    }

    private void markTargetedAndStartingPoint() {
        this.isTargeted = true;
        EventHelper.INSTANCE.reset();
        this.log(100, "appKey", Const.APP_KEY, "domain", API.HOST_URL, "appId", Const.APP_ID, "deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()), "userId", UserProfile.USER_ID, "deviceInfo", String.format("%s %s %s", Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE), "sdkVersion", "4.6.0", "originLanguage", Const.ORIGINAL_LANGUAGE, "countryCode", DeviceInfoUtil.getInstance().getSimCountryIso(), "timeZone", new Date().toString());
    }

    static {
        SAMPLING_LOG_SIZE_LIMIT = 0x200000L;
        SAMPLING_LOG_VERSION = "1.0";
    }
}

