/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.resource;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.Set;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.track.resource.tracker.InitEventTracker;
import net.aihelp.data.track.resource.tracker.InitResTracker;
import net.aihelp.data.track.resource.tracker.TemplateResTracker;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import org.json.JSONObject;

public class SyncHelper {
    private static final int RESOURCE_REQUEST_THRESHOLD = 5000;

    public static void syncResultToServer(int mode, boolean isSuccess, int fetchSource) {
        long duration = -1L;
        HashMap<String, Long> loadingMap = null;
        if (fetchSource == 1) {
            duration = InitResTracker.INSTANCE.getRequestDuration();
            loadingMap = InitResTracker.INSTANCE.getLoadingMap();
        } else if (fetchSource == 2) {
            duration = TemplateResTracker.INSTANCE.getRequestDuration();
            loadingMap = TemplateResTracker.INSTANCE.getLoadingMap();
        }
        String key = LocalizeUtil.getFolderName(mode).replace("/", "");
        if (loadingMap != null) {
            loadingMap.put(key, isSuccess ? duration : -1L);
        }
        if (InitResTracker.INSTANCE.isReady() && fetchSource == 1 || TemplateResTracker.INSTANCE.isReady() && fetchSource == 2) {
            SyncHelper.syncToServer(duration, loadingMap);
        }
    }

    private static void syncToServer(long duration, HashMap<String, Long> loadingMap) {
        AIHelpRequest request = AIHelpRequest.getInstance();
        JSONObject trackData = SyncHelper.getTrackData(duration, loadingMap);
        if (duration >= 5000L) {
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME, trackData, null);
        } else {
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION, trackData, null);
        }
    }

    public static JSONObject getTrackData(long loadingDuration, HashMap<String, Long> loadingMap) {
        JSONObject trackData = SyncHelper.getCommonParams();
        JsonHelper.put(trackData, "success", InitEventTracker.INSTANCE.isInitSuccess());
        JsonHelper.put(trackData, "initLoadingTime", InitEventTracker.INSTANCE.getInitDuration());
        JsonHelper.put(trackData, "sdkSettingLoadingTime", loadingDuration);
        if (loadingMap != null) {
            JSONObject sdkSettingDict = JsonHelper.getJsonObject();
            Set<String> resourceKeys = loadingMap.keySet();
            for (String resourceKey : resourceKeys) {
                Long duration = loadingMap.get(resourceKey);
                if (TextUtils.isEmpty((CharSequence)resourceKey) || duration == null) continue;
                JsonHelper.put(sdkSettingDict, resourceKey, duration);
            }
            JsonHelper.put(trackData, "sdkSettingDict", sdkSettingDict);
        }
        return trackData;
    }

    public static JSONObject getCommonParams() {
        JSONObject map = new JSONObject();
        try {
            map.put("time", (Object)String.valueOf(System.currentTimeMillis()));
            map.put("deviceId", (Object)DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("countryCode", (Object)DeviceInfoUtil.getInstance().getSimCountryIso());
            map.put("userId", (Object)UserProfile.USER_ID);
            map.put("platform", 2);
            map.put("lan", (Object)Const.CORRECT_LANGUAGE);
            map.put("appId", (Object)Const.APP_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void reset() {
        InitEventTracker.INSTANCE.reset();
        InitResTracker.INSTANCE.reset();
        TemplateResTracker.INSTANCE.reset();
    }
}

