/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.resource.tracker;

import java.util.HashMap;
import net.aihelp.common.API;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.data.track.resource.SyncHelper;

public enum InitEventTracker {
    INSTANCE;

    private boolean isInitSuccess;
    private long initStartTime;
    private long initEndTime;
    private long initDuration;
    private HashMap<String, Long> resLoadingMap = new HashMap();

    public void markInitStarted() {
        this.initStartTime = System.currentTimeMillis();
    }

    public void markInitEnded(boolean initSuccess) {
        this.isInitSuccess = initSuccess;
        this.initEndTime = System.currentTimeMillis();
        this.initDuration = this.initEndTime - this.initStartTime;
        if (!initSuccess) {
            AIHelpRequest request = AIHelpRequest.getInstance();
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME, SyncHelper.getTrackData(-1L, null), null);
        }
    }

    public void reset() {
        this.isInitSuccess = false;
        this.initStartTime = 0L;
        this.initEndTime = 0L;
        this.resLoadingMap = new HashMap();
    }

    public boolean isInitSuccess() {
        return this.isInitSuccess;
    }

    public long getInitEndTime() {
        return this.initEndTime;
    }

    public long getInitDuration() {
        return this.initDuration;
    }

    public HashMap<String, Long> getResLoadingMap() {
        return this.resLoadingMap;
    }
}

