/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.resource.tracker;

import java.util.HashMap;

public enum InitResTracker {
    INSTANCE;

    private long initResRequestTime = -1L;
    private int initResourceCount = -1;
    private HashMap<String, Long> loadingMap = new HashMap();

    public void onRequested(int resourceCount) {
        this.initResRequestTime = System.currentTimeMillis();
        this.initResourceCount = resourceCount;
        if (this.initResourceCount == 0) {
            // empty if block
        }
    }

    public void onRetrieved() {
        --this.initResourceCount;
        if (this.initResourceCount == 0) {
            // empty if block
        }
    }

    public boolean isReady() {
        return this.initResRequestTime > 0L && this.initResourceCount == 0;
    }

    public long getRequestDuration() {
        if (this.initResRequestTime > 0L) {
            return System.currentTimeMillis() - this.initResRequestTime;
        }
        return -1L;
    }

    public void reset() {
        this.initResRequestTime = -1L;
        this.initResourceCount = -1;
        this.loadingMap = new HashMap();
    }

    public HashMap<String, Long> getLoadingMap() {
        return this.loadingMap;
    }
}

