/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.resource.tracker;

import java.util.HashMap;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.TemplateReadyEvent;
import net.aihelp.data.track.event.EventTracker;

public enum TemplateResTracker {
    INSTANCE;

    private long requestStartTime = -1L;
    private int templateResourceCount = -1;
    private HashMap<String, Long> loadingMap = new HashMap();

    public void onRequested(int resourceCount) {
        this.requestStartTime = System.currentTimeMillis();
        this.templateResourceCount = resourceCount;
        if (this.templateResourceCount == 0 && EventBus.getDefault().hasSubscriberForEvent(TemplateReadyEvent.class)) {
            EventBus.getDefault().post(new TemplateReadyEvent());
        }
    }

    public void onRetrieved() {
        --this.templateResourceCount;
        if (this.templateResourceCount == 0) {
            EventTracker.INSTANCE.log(404, new Object[0]);
            EventBus.getDefault().post(new TemplateReadyEvent());
        }
    }

    public boolean isReady() {
        return this.requestStartTime > 0L && this.templateResourceCount == 0;
    }

    public long getRequestDuration() {
        if (this.requestStartTime > 0L) {
            return System.currentTimeMillis() - this.requestStartTime;
        }
        return -1L;
    }

    public void reset() {
        this.requestStartTime = -1L;
        this.templateResourceCount = -1;
        this.loadingMap = new HashMap();
    }

    public HashMap<String, Long> getLoadingMap() {
        return this.loadingMap;
    }
}

