/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.track.ue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class UETracker {
    public static final int DURATION_TEMPLATE_DOWNLOADING = 1;
    public static final int DURATION_CS_LOADING = 2;
    public static final int DURATION_FORM_RENDERING = 3;
    public static final int COUNT_ERROR_ENTRANCE = 4;
    public static final int AIHELP_IN_STACK = 5;

    public static HashMap<Integer, List<Long>> calculateUETrack(String content) {
        HashMap<Integer, List<Long>> result = UETracker.getResult(content);
        List<Long> downloadTemplateDuration = result.get(1);
        List<Long> csLoadingDuration = result.get(2);
        List<Long> webRenderDuration = result.get(3);
        List<Long> errEntranceCounts = result.get(4);
        int errCount = errEntranceCounts != null ? errEntranceCounts.size() : 0;
        boolean forceExitInAIHelp = result.containsKey(5);
        TLog.d("UETracker", String.format("downloadTemplateDuration: %s, csLoadingDuration: %s, webRenderDuration: %s, errCount: %s, forceExit: %s", downloadTemplateDuration, csLoadingDuration, webRenderDuration, errCount, forceExitInAIHelp));
        return result;
    }

    private static HashMap<Integer, List<Long>> getResult(String content) {
        HashMap<Integer, Long> mapStartTime = new HashMap<Integer, Long>();
        HashMap<Integer, List<Long>> mapList = new HashMap<Integer, List<Long>>();
        JSONArray eventArray = JsonHelper.getJsonArray(content);
        for (int i = 0; i < eventArray.length(); ++i) {
            Long timeUrlClicked;
            Long timeLoadingBegan;
            JSONObject eventObject = JsonHelper.getJsonObject(eventArray, i);
            long eventType = eventObject.optInt("type", 0);
            long time = eventObject.optLong("time", -1L);
            if (eventType == 101L) {
                mapStartTime.put(1, time);
            }
            if (eventType == 404L) {
                Long timeSDKOpened = (Long)mapStartTime.get(1);
                if (timeSDKOpened != null) {
                    List<Long> openSdkDurationEvents = mapList.get(1);
                    if (openSdkDurationEvents == null) {
                        openSdkDurationEvents = new ArrayList<Long>();
                    }
                    openSdkDurationEvents.add(time - timeSDKOpened);
                    mapList.put(1, openSdkDurationEvents);
                    mapStartTime.remove(1);
                }
                mapList.put(5, null);
            }
            if (eventType == 300L) {
                mapStartTime.put(2, time);
            }
            if (eventType == 304L && (timeLoadingBegan = (Long)mapStartTime.get(2)) != null) {
                List<Long> loadingDurationEvents = mapList.get(2);
                if (loadingDurationEvents == null) {
                    loadingDurationEvents = new ArrayList<Long>();
                }
                loadingDurationEvents.add(time - timeLoadingBegan);
                mapList.put(2, loadingDurationEvents);
                mapStartTime.remove(2);
            }
            if (eventType == 318L) {
                mapStartTime.put(3, time);
            }
            if (eventType == 403L && (timeUrlClicked = (Long)mapStartTime.get(3)) != null) {
                List<Long> webRenderDurationEvents = mapList.get(3);
                if (webRenderDurationEvents == null) {
                    webRenderDurationEvents = new ArrayList<Long>();
                }
                webRenderDurationEvents.add(time - timeUrlClicked);
                mapList.put(3, webRenderDurationEvents);
                mapStartTime.remove(3);
            }
            if (eventType == 402L) {
                List<Long> errEntranceEvents = mapList.get(4);
                if (errEntranceEvents == null) {
                    errEntranceEvents = new ArrayList<Long>();
                }
                errEntranceEvents.add(time);
                mapList.put(4, errEntranceEvents);
            }
            if (eventType != 401L) continue;
            mapList.remove(5);
        }
        return mapList;
    }
}

