/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.content.Context;
import androidx.annotation.Keep;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.config.ApiConfig;
import net.aihelp.config.UserConfig;
import net.aihelp.config.enums.PublishCountryOrRegion;
import net.aihelp.config.enums.PushPlatform;
import net.aihelp.config.enums.ShowConversationMoment;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.exception.AIHelpInitException;
import net.aihelp.init.AIHelpCore;
import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;
import net.aihelp.utils.DeviceUuidFactory;

@Keep
public class AIHelpSupport {
    public static void init(Context context, String appKey, String domain, String appId) {
        AIHelpSupport.init(context, appKey, domain, appId, Const.CORRECT_LANGUAGE);
    }

    public static void init(Context context, String appKey, String domain, String appId, String language) throws AIHelpInitException {
        AIHelpCore.getInstance().init(context, appKey, domain, appId, language);
    }

    public static void setOnAIHelpInitializedCallback(final OnAIHelpInitializedCallback listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setOnAIHelpInitializedCallback(listener);
            }
        });
    }

    public static boolean show(String entranceId) {
        return AIHelpCore.getInstance().show(new ApiConfig.Builder().setEntranceId(entranceId).build());
    }

    public static boolean show(ApiConfig config) {
        return AIHelpCore.getInstance().show(config);
    }

    public static void showSingleFAQ(final String faqId, final ShowConversationMoment moment) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().showSingleFAQ(faqId, moment);
            }
        });
    }

    public static void showUrl(final String url) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().showUrl(url);
            }
        });
    }

    public static void updateUserInfo(final UserConfig config) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().updateUserInfo(config);
            }
        });
    }

    public static void resetUserInfo() {
        Context context = AIHelpContext.getInstance().getContext();
        if (context != null) {
            UserConfig resetUser = new UserConfig.Builder().setUserId(DeviceUuidFactory.id(context)).setServerId("-1").setUserName("anonymous").build();
            AIHelpSupport.updateUserInfo(resetUser);
        }
    }

    public static void updateSDKLanguage(final String sdkLanguage) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().updateSDKLanguage(sdkLanguage);
            }
        });
    }

    public static void startUnreadMessageCountPolling(final OnMessageCountArrivedCallback listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().startUnreadMessageCountPolling(listener);
            }
        });
    }

    public static void fetchUnreadMessageCount(final OnMessageCountArrivedCallback listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().fetchUnreadMessageCount(listener);
            }
        });
    }

    public static void stopUnreadMessageCountPolling() {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().stopUnreadMessageCountPolling();
            }
        });
    }

    public static void setUploadLogPath(final String logPath) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setUploadLogPath(logPath);
            }
        });
    }

    public static void setPushTokenAndPlatform(final String pushToken, final PushPlatform pushPlatform) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setPushTokenAndPlatform(pushToken, pushPlatform);
            }
        });
    }

    public static void setNetworkCheckHostAddress(String hostAddress) {
        AIHelpSupport.setNetworkCheckHostAddress(hostAddress, null);
    }

    public static void setNetworkCheckHostAddress(final String hostAddress, final OnNetworkCheckResultCallback listener) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setNetworkCheckHostAddress(hostAddress, listener);
            }
        });
    }

    public static void setOnSpecificFormSubmittedCallback(final OnSpecificFormSubmittedCallback callback) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setOnSpecificFormSubmittedCallback(callback);
            }
        });
    }

    public static void setOnAIHelpSessionOpenCallback(final OnAIHelpSessionOpenCallback callback) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setOnAIHelpSessionOpenCallback(callback);
            }
        });
    }

    public static void setOnAIHelpSessionCloseCallback(final OnAIHelpSessionCloseCallback callback) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setOnAIHelpSessionCloseCallback(callback);
            }
        });
    }

    public static void setOnSpecificUrlClickedCallback(final OnSpecificUrlClickedCallback callback) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().setOnSpecificUrlClickedCallback(callback);
            }
        });
    }

    public static void additionalSupportFor(final PublishCountryOrRegion countryOrRegion) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AIHelpCore.getInstance().additionalSupportFor(countryOrRegion);
            }
        });
    }

    public static String getSDKVersion() {
        return "4.6.0";
    }

    public static boolean isAIHelpShowing() {
        return Const.IS_SDK_SHOWING;
    }

    public static void enableLogging(boolean enable) {
        AIHelpCore.getInstance().enableLogging(enable);
    }

    public static void close() {
        AIHelpCore.getInstance().close();
    }
}

