/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import androidx.annotation.Keep;
import net.aihelp.init.AIHelpSupport;
import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;

@Keep
public class CallbackHelper {
    public static void registerCocos2dxCallback(final int callbackType, Object ... obj) {
        switch (callbackType) {
            case 1001: {
                AIHelpSupport.setOnAIHelpInitializedCallback(new OnAIHelpInitializedCallback(){

                    @Override
                    public void onAIHelpInitialized(boolean isSuccess, String message) {
                        CallbackHelper.handleCocos2dxCallback(callbackType, isSuccess, message);
                    }
                });
                break;
            }
            case 1002: {
                if (obj == null || obj.length <= 0 || !(obj[0] instanceof String)) break;
                AIHelpSupport.setNetworkCheckHostAddress((String)obj[0], new OnNetworkCheckResultCallback(){

                    @Override
                    public void onNetworkCheckResult(String netLog) {
                        CallbackHelper.handleCocos2dxCallback(callbackType, netLog);
                    }
                });
                break;
            }
            case 1003: {
                AIHelpSupport.startUnreadMessageCountPolling(new OnMessageCountArrivedCallback(){

                    @Override
                    public void onMessageCountArrived(int msgCount) {
                        CallbackHelper.handleCocos2dxCallback(callbackType, msgCount);
                    }
                });
                break;
            }
            case 1004: {
                AIHelpSupport.setOnSpecificFormSubmittedCallback(new OnSpecificFormSubmittedCallback(){

                    @Override
                    public void onFormSubmitted() {
                        CallbackHelper.handleCocos2dxCallback(callbackType, new Object[0]);
                    }
                });
                break;
            }
            case 1005: {
                AIHelpSupport.setOnAIHelpSessionOpenCallback(new OnAIHelpSessionOpenCallback(){

                    @Override
                    public void onAIHelpSessionOpened() {
                        CallbackHelper.handleCocos2dxCallback(callbackType, new Object[0]);
                    }
                });
                break;
            }
            case 1006: {
                AIHelpSupport.setOnAIHelpSessionCloseCallback(new OnAIHelpSessionCloseCallback(){

                    @Override
                    public void onAIHelpSessionClosed() {
                        CallbackHelper.handleCocos2dxCallback(callbackType, new Object[0]);
                    }
                });
                break;
            }
            case 1008: {
                AIHelpSupport.setOnSpecificUrlClickedCallback(new OnSpecificUrlClickedCallback(){

                    @Override
                    public void onSpecificUrlClicked(String url) {
                        CallbackHelper.handleCocos2dxCallback(callbackType, url);
                    }
                });
            }
        }
    }

    public static native void handleCocos2dxCallback(int var0, Object ... var1);
}

