/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;

public class ConfigUtil {
    public static final int FLAG_STORY_CONTEXT = 1004;
    public static final int FLAG_STORY_SPLITTERS = 1005;
    public static final int FLAG_STORY_SUBSTITUTIONS = 1006;
    private static final String AIBotContextStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<context>\n  <bot name=\"id\" value=\"test_cases\"/>\n  <bot name=\"output\" value=\"Logs/gossip.txt\"/>\n  <bot name=\"randomSeed\" value=\"1\"/>\n  <bot name=\"series\" value=\"Alpha\"/>\n  <bot name=\"version\" value=\"0.7.5 Alpha\"/>\n  <set name=\"dateFormat\" value=\"yyyy-MM-dd HH:mm:ss\"/>\n  <set name=\"name\" value=\"Hero\"/>\n  <set name=\"me\" value=\"Maggie\"/>\n  <set name=\"engine\" value=\"ChatterBean\"/>\n  <set name=\"topic\" value=\"*\"/>\n</context>";
    private static final String AIBotSplittersStr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<splitters>\n  <splitter value=\"...\" type=\"sentence\"/>\n  <splitter value=\",\" type=\"word\"/>\n  <splitter value=\":\" type=\"word\"/>\n</splitters>";
    private static final String AIBotSubstitutionsStr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<substitutions>\n  <input>\n    <correction>\n      <substitute find=\"=reply\" replace=\"\"/>\n      <substitute find=\"name=reset\" replace=\"\"/>\n      <substitute find=\":-)\" replace=\" smile \"/>\n      <substitute find=\":)\" replace=\" smile \"/>\n      <substitute find=\",)\" replace=\" smile \"/>\n      <substitute find=\";)\" replace=\" smile \"/>\n      <substitute find=\";-)\" replace=\" smile \"/>\n      <substitute find=\"&quot;\" replace=\"\"/>\n      <substitute find=\"/\" replace=\" \"/>\n      <substitute find=\"&gt;\" replace=\" gt \"/>\n      <substitute find=\"&lt;\" replace=\" lt \"/>\n      <substitute find=\"(\" replace=\" \"/>\n      <substitute find=\")\" replace=\" \"/>\n      <substitute find=\"&amp;\" replace=\" \"/>\n      <substitute find=\"=\" replace=\" \"/>\n      <substitute find=\"  \" replace=\" \"/>\n      <substitute find=\" l a \" replace=\" la \"/>\n      <substitute find=\" o k \" replace=\" ok \"/>\n      <substitute find=\" p s \" replace=\" ps \"/>\n      <substitute find=\" ohh\" replace=\" oh\"/>\n      <substitute find=\" hehe\" replace=\" he\"/>\n      <substitute find=\" haha\" replace=\" ha\"/>    \n      <substitute find=\" hellp \" replace=\" help \"/>\n      <substitute find=\" becuse \" replace=\" because \"/>\n      <substitute find=\" beleive \" replace=\" believe \"/>\n      <substitute find=\" becasue \" replace=\" because \"/>\n      <substitute find=\" becuase \" replace=\" because \"/>\n      <substitute find=\" becouse \" replace=\" because \"/>\n      <substitute find=\" reductionalism \" replace=\" reductionism \"/>\n      <substitute find=\" loebner price \" replace=\" loebner prize \"/>\n      <substitute find=\" its a \" replace=\" it is a \"/>\n      <substitute find=\" noi \" replace=\" no I \"/>\n      <substitute find=\" fav \" replace=\" favorite \"/>\n      <substitute find=\" yesi \" replace=\" yes I \"/>\n      <substitute find=\" yesit \" replace=\" yes it \"/>\n      <substitute find=\" iam \" replace=\" I am \"/>\n      <substitute find=\" welli \" replace=\" well I \"/>\n      <substitute find=\" wellit \" replace=\" well it \"/>\n      <substitute find=\" amfine \" replace=\" am fine \"/>\n      <substitute find=\" aman \" replace=\" am an \"/>\n      <substitute find=\" amon \" replace=\" am on \"/>\n      <substitute find=\" amnot \" replace=\" am not \"/>\n      <substitute find=\" realy \" replace=\" really \"/>\n      <substitute find=\" iamusing \" replace=\" I am using \"/>\n      <substitute find=\" amleaving \" replace=\" am leaving \"/>\n      <substitute find=\" mis placed \" replace=\" misplaced \"/>\n      <substitute find=\" yeah \" replace=\" yes \"/>\n      <substitute find=\" yep \" replace=\" yes \"/>\n      <substitute find=\" yha \" replace=\" yes \"/>\n      <substitute find=\" yuo \" replace=\" you \"/>\n      <substitute find=\" wanna \" replace=\" want to \"/>\n      <substitute find=\" iama \" replace=\" I am a \"/>\n      <substitute find=\" iamasking \" replace=\" I am asking \"/>\n      <substitute find=\" iamdoing \" replace=\" I am doing \"/>\n      <substitute find=\" iamfrom \" replace=\" I am from \"/>\n      <substitute find=\" iamin \" replace=\" I am in \"/>\n      <substitute find=\" iamok \" replace=\" I am ok \"/>\n      <substitute find=\" iamsorry \" replace=\" I am sorry \"/>\n      <substitute find=\" iamtalking \" replace=\" I am talking \"/>\n      <substitute find=\" iamtired \" replace=\" I am tired \"/>\n      <substitute find=\" down load \" replace=\" download \"/>\n      <substitute find=\" remeber \" replace=\" remember \"/>\n      <substitute find=\" waht \" replace=\" what \"/>\n      <substitute find=\" wallance \" replace=\" wallace \"/>\n      <substitute find=\" you r \" replace=\" you are \"/>\n      <substitute find=\" u \" replace=\" you \"/>\n      <substitute find=\" ur \" replace=\" your \"/>\n      <substitute find=\" you'd \" replace=\" you would \"/>\n      <substitute find=\" you're \" replace=\" you are \"/>\n      <substitute find=\" you re \" replace=\" you are \"/>\n      <substitute find=\" you've \" replace=\" you have \"/>\n      <substitute find=\" you ve \" replace=\" you have \"/>\n      <substitute find=\" you'll \" replace=\" you will \"/>\n      <substitute find=\" you ll \" replace=\" you will \"/>\n      <substitute find=\" youre \" replace=\" you are \"/>\n      <substitute find=\" didnt \" replace=\" did not \"/>\n      <substitute find=\" did'nt \" replace=\" did not \"/>\n      <substitute find=\" couldn't \" replace=\" could not \"/>\n      <substitute find=\" couldn t \" replace=\" could not \"/>\n      <substitute find=\" didn t \" replace=\" did not \"/>\n      <substitute find=\" ain't \" replace=\" is not \"/>\n      <substitute find=\" ain t \" replace=\" is not \"/>\n      <substitute find=\" isn't \" replace=\" is not \"/>\n      <substitute find=\" isn t \" replace=\" is not \"/>\n      <substitute find=\" isnt \" replace=\" is not \"/>\n      <substitute find=\" it'll \" replace=\" it will \"/>\n      <substitute find=\" it's \" replace=\" it is \"/>\n      <substitute find=\" it s \" replace=\" it is \"/>\n      <substitute find=\" are'nt \" replace=\" are not \"/>\n      <substitute find=\" arent \" replace=\" are not \"/>\n      <substitute find=\" aren't \" replace=\" are not \"/>\n      <substitute find=\" aren t \" replace=\" are not \"/>\n      <substitute find=\" arn t \" replace=\" are not \"/>\n      <substitute find=\" where's \" replace=\" where is \"/>\n      <substitute find=\" where s \" replace=\" where is \"/>\n      <substitute find=\" haven't \" replace=\" have not \"/>\n      <substitute find=\" havent \" replace=\" have not \"/>\n      <substitute find=\" hasn't \" replace=\" has not \"/>\n      <substitute find=\" hasn t \" replace=\" has not \"/>\n      <substitute find=\" weren t \" replace=\" were not \"/>\n      <substitute find=\" weren't \" replace=\" were not \"/>\n      <substitute find=\" werent \" replace=\" were not \"/>\n      <substitute find=\" can't \" replace=\" can not \"/>\n      <substitute find=\" can t \" replace=\" can not \"/>\n      <substitute find=\" cant \" replace=\" can not \"/>\n      <substitute find=\" whos \" replace=\" who is \"/>\n      <substitute find=\" how's \" replace=\" how is \"/>\n      <substitute find=\" how're \" replace=\" how are \"/>\n      <substitute find=\" how s \" replace=\" how is \"/>\n      <substitute find=\" how'd \" replace=\" how did \"/>\n      <substitute find=\" how d \" replace=\" how did \"/>\n      <substitute find=\" hows \" replace=\" how is \"/>\n      <substitute find=\" whats \" replace=\" what is \"/>\n      <substitute find=\" name's \" replace=\" name is \"/>\n      <substitute find=\" who's \" replace=\" who is \"/>\n      <substitute find=\" who s \" replace=\" who is \"/>\n      <substitute find=\" waht's \" replace=\" what is \"/>\n      <substitute find=\" what's \" replace=\" what is \"/>\n      <substitute find=\" what s \" replace=\" what is \"/>\n      <substitute find=\" that's \" replace=\" that is \"/>\n      <substitute find=\" there's \" replace=\" there is \"/>\n      <substitute find=\" there s \" replace=\" there is \"/>\n      <substitute find=\" theres \" replace=\" there is \"/>\n      <substitute find=\" thats \" replace=\" that is \"/>\n      <substitute find=\" whats \" replace=\" what is \"/>\n      <substitute find=\" doesn't \" replace=\" does not \"/>\n      <substitute find=\" doesn t \" replace=\" does not \"/>\n      <substitute find=\" doesnt \" replace=\" does not \"/>\n      <substitute find=\" don't \" replace=\" do not \"/>\n      <substitute find=\" don t \" replace=\" do not \"/>\n      <substitute find=\" dont \" replace=\" do not \"/>\n      <substitute find=\" do nt \" replace=\" do not \"/>\n      <substitute find=\" do'nt \" replace=\" do not \"/>\n      <substitute find=\" won't \" replace=\" will not \"/>\n      <substitute find=\" wont \" replace=\" will not \"/>\n      <substitute find=\" won t \" replace=\" will not \"/>\n      <substitute find=\" let's \" replace=\" let us \"/>\n      <substitute find=\" they're \" replace=\" they are \"/>\n      <substitute find=\" they re \" replace=\" they are \"/>\n      <substitute find=\" wasn't \" replace=\" was not \"/>\n      <substitute find=\" wasn t \" replace=\" was not \"/>\n      <substitute find=\" wasnt \" replace=\" was not \"/>\n      <substitute find=\" hadn't \" replace=\" had not \"/>\n      <substitute find=\" hadn t \" replace=\" had not \"/>\n      <substitute find=\" wouldn't \" replace=\" would not \"/>\n      <substitute find=\" wouldn t \" replace=\" would not \"/>\n      <substitute find=\" wouldnt \" replace=\" would not \"/>\n      <substitute find=\" shouldn't \" replace=\" should not \"/>\n      <substitute find=\" shouldnt \" replace=\" should not \"/>\n      <substitute find=\" favourite \" replace=\" favorite \"/>\n      <substitute find=\" colour \" replace=\" color \"/>\n      <substitute find=\" we'll \" replace=\" we will \"/>\n      <substitute find=\" we ll \" replace=\" we will \"/>\n      <substitute find=\" he'll \" replace=\" he will \"/>\n      <substitute find=\" he ll \" replace=\" he will \"/>\n      <substitute find=\" i'll \" replace=\" I will \"/>\n      <substitute find=\" ive \" replace=\" I have \"/>\n      <substitute find=\" i've \" replace=\" I have \"/>\n      <substitute find=\" i ve \" replace=\" I have \"/>\n      <substitute find=\" i'd \" replace=\" I would \"/>\n      <substitute find=\" i'm \" replace=\" I am \"/>\n      <substitute find=\" i m \" replace=\" I am \"/>\n      <substitute find=\" we've \" replace=\" we have \"/>\n      <substitute find=\" we're \" replace=\" we are \"/>\n      <substitute find=\" she's \" replace=\" she is \"/>\n      <substitute find=\" shes \" replace=\" she is \"/>\n      <substitute find=\" she'd \" replace=\" she would \"/>\n      <substitute find=\" she d \" replace=\" she would \"/>\n      <substitute find=\" shed \" replace=\" she would \"/>\n      <substitute find=\" he'd \" replace=\" he would \"/>\n      <substitute find=\" he d \" replace=\" he would \"/>\n      <substitute find=\" hed \" replace=\" he would \"/>\n      <substitute find=\" he's \" replace=\" he is \"/>\n      <substitute find=\" we ve \" replace=\" we have \"/>\n      <substitute find=\" we re \" replace=\" we are \"/>\n      <substitute find=\" she s \" replace=\" she is \"/>\n      <substitute find=\" he s \" replace=\" he is \"/>\n    </correction>\n    <protection>\n      <substitute find=\".&quot;\" replace=\" &quot;\"/>\n      <substitute find=\"?&quot;\" replace=\" &quot;\"/>\n      <substitute find=\"!&quot;\" replace=\" &quot;\"/>\n      <substitute find=\"{\" replace=\" beginscript \"/>\n      <substitute find=\"}\" replace=\" endscript \"/>\n      <substitute find=\"/\" replace=\" \"/>\n      <substitute find=\"\\\" replace=\" \"/>\n      <substitute find=\":0\" replace=\" 0\"/>\n      <substitute find=\": 0\" replace=\"  0\"/>\n      <substitute find=\":1\" replace=\" 1\"/>\n      <substitute find=\": 1\" replace=\"  1\"/>\n      <substitute find=\":2\" replace=\" 2\"/>\n      <substitute find=\": 2\" replace=\"  2\"/>\n      <substitute find=\":3\" replace=\" 3\"/>\n      <substitute find=\": 3\" replace=\"  3\"/>\n      <substitute find=\":4\" replace=\" 4\"/>\n      <substitute find=\": 4\" replace=\"  4\"/>\n      <substitute find=\":5\" replace=\" 5\"/>\n      <substitute find=\": 5\" replace=\"  5\"/>\n      <substitute find=\".0\" replace=\"p0\"/>\n      <substitute find=\".1\" replace=\"p1\"/>\n      <substitute find=\".2\" replace=\"p3\"/>\n      <substitute find=\".4\" replace=\"p4\"/>\n      <substitute find=\".5\" replace=\"p5\"/>\n      <substitute find=\".6\" replace=\"p6\"/>\n      <substitute find=\".7\" replace=\"p7\"/>\n      <substitute find=\".8\" replace=\"p8\"/>\n      <substitute find=\".9\" replace=\"p9\"/>\n      <substitute find=\" dr. \" replace=\" Dr \"/>\n      <substitute find=\" dr.w\" replace=\" Dr w\"/>\n      <substitute find=\" dr . \" replace=\" Dr \"/>\n      <substitute find=\" mr. \" replace=\" Mr \"/>\n      <substitute find=\" mrs. \" replace=\" Mrs \"/>\n      <substitute find=\" st. \" replace=\" St \"/>\n      <substitute find=\"www.\" replace=\" www \"/>\n      <substitute find=\" botspot.\" replace=\" botspot dot \"/>\n      <substitute find=\" amused.com\" replace=\" amused dot com \"/>\n      <substitute find=\" whatis.\" replace=\" whatis dot \"/>\n      <substitute find=\".com \" replace=\" com \"/>\n      <substitute find=\".net \" replace=\" net \"/>\n      <substitute find=\".org \" replace=\" dot org \"/>\n      <substitute find=\".edu \" replace=\" dot edu \"/>\n      <substitute find=\".uk \" replace=\" dot uk \"/>\n      <substitute find=\".jp \" replace=\" dot jp \"/>\n      <substitute find=\".au \" replace=\" dot au \"/>\n      <substitute find=\".co \" replace=\" dot co \"/>\n      <substitute find=\".ac \" replace=\" dot ac \"/>\n      <substitute find=\" o.k. \" replace=\" ok \"/>\n      <substitute find=\" o. k. \" replace=\" ok \"/>\n      <substitute find=\" l.l. \" replace=\" l l \"/>\n      <substitute find=\" p.s. \" replace=\" ps \"/>\n      <substitute find=\" alicebot \" replace=\" ALICE \"/>\n      <substitute find=\" a l i c e \" replace=\" ALICE \"/>\n      <substitute find=\" a.l.i.c.e. \" replace=\" ALICE \"/>\n      <substitute find=\" a.l.i.c.e \" replace=\" ALICE \"/>\n      <substitute find=\" i.c.e \" replace=\" i c e \"/>\n      <substitute find=\" e l v i s \" replace=\" ELVIS \"/>\n      <substitute find=\" e.l.v.i.s. \" replace=\" ELVIS \"/>\n      <substitute find=\" e.l.v.i.s \" replace=\" ELVIS \"/>\n      <substitute find=\" v.i.s \" replace=\" v i s \"/>\n      <substitute find=\" h a l \" replace=\" hal \"/>\n      <substitute find=\" h.a.l. \" replace=\" hal \"/>\n      <substitute find=\" u s a \" replace=\" USA \"/>\n      <substitute find=\" u. s. a. \" replace=\" USA \"/>\n      <substitute find=\" u.s.a. \" replace=\" USA \"/>\n      <substitute find=\" u.s. \" replace=\" USA \"/>\n      <substitute find=\" ph.d. \" replace=\" PhD \"/>\n      <substitute find=\" a.\" replace=\" a \"/>\n      <substitute find=\" b.\" replace=\" b \"/>\n      <substitute find=\" c.\" replace=\" c \"/>\n      <substitute find=\" d.\" replace=\" d \"/>\n      <substitute find=\" e.\" replace=\" e \"/>\n      <substitute find=\" f.\" replace=\" f \"/>\n      <substitute find=\" g.\" replace=\" g \"/>\n      <substitute find=\" h.\" replace=\" h \"/>\n      <substitute find=\" i.\" replace=\" i \"/>\n      <substitute find=\" j.\" replace=\" j \"/>\n      <substitute find=\" k.\" replace=\" k \"/>\n      <substitute find=\" l.\" replace=\" l \"/>\n      <substitute find=\" m.\" replace=\" m \"/>\n      <substitute find=\" n.\" replace=\" n \"/>\n      <substitute find=\" p.\" replace=\" p \"/>\n      <substitute find=\" o.\" replace=\" o \"/>\n      <substitute find=\" q.\" replace=\" q \"/>\n      <substitute find=\" r.\" replace=\" r \"/>\n      <substitute find=\" s.\" replace=\" s \"/>\n      <substitute find=\" t.\" replace=\" t \"/>\n      <substitute find=\" u.\" replace=\" u \"/>\n      <substitute find=\" v.\" replace=\" v \"/>\n      <substitute find=\" x.\" replace=\" x \"/>\n      <substitute find=\" y.\" replace=\" y \"/>\n      <substitute find=\" w.\" replace=\" w \"/>\n      <substitute find=\" z.\" replace=\" z \"/>\n      <substitute find=\".aiml\" replace=\" aiml\"/>\n      <substitute find=\".html\" replace=\" html\"/>\n      <substitute find=\".shtml\" replace=\" shtml\"/>\n      <substitute find=\".jar\" replace=\" jar\"/>\n      <substitute find=\".zip\" replace=\" zip\"/>\n      <substitute find=\", but \" replace=\".  \"/>\n      <substitute find=\", and \" replace=\".     \"/>\n      <substitute find=\",and \"  replace=\".    \"/>\n      <substitute find=\",but \" replace=\".  \"/>\n      <substitute find=\"  but \" replace=\".  \"/>\n      <substitute find=\"  and \" replace=\".  \"/>\n      <substitute find=\", i \" replace=\".  I \"/>\n      <substitute find=\", you \" replace=\".  you \"/>\n      <substitute find=\",i \" replace=\".  I \"/>\n      <substitute find=\",you \" replace=\".  you \"/>\n      <substitute find=\", what \" replace=\".  what \"/>\n      <substitute find=\",what \" replace=\".  what \"/>\n      <substitute find=\", do \" replace=\".  do \"/>\n      <substitute find=\",do \" replace=\".  do \"/>\n    </protection>\n  </input>\n  <gender>\n    <substitute find=\" he \" replace=\"she\"/>\n    <substitute find=\" she \" replace=\"he\"/>\n    <substitute find=\" to him \" replace=\"to her\"/>\n    <substitute find=\" for him \" replace=\"for her\"/>\n    <substitute find=\" with him \" replace=\"with her\"/>\n    <substitute find=\" on him \" replace=\"on her\"/>\n    <substitute find=\" in him \" replace=\"in her\"/>\n    <substitute find=\" to her \" replace=\"to him\"/>\n    <substitute find=\" for her \" replace=\"for him\"/>\n    <substitute find=\" with her \" replace=\"with him\"/>\n    <substitute find=\" on her \" replace=\"on him\"/>\n    <substitute find=\" in her \" replace=\"in him\"/>\n    <substitute find=\" his \" replace=\"her\"/>\n    <substitute find=\" her \" replace=\"his\"/>\n    <substitute find=\" him \" replace=\"her\"/>\n  </gender>\n  <person>\n    <substitute find=\" I was \" replace=\"he or she was\"/>\n    <substitute find=\" he was \" replace=\"I was\"/>\n    <substitute find=\" she was \" replace=\"I was\"/>\n    <substitute find=\" I am \" replace=\"he or she is\"/>\n    <substitute find=\" I \" replace=\"he or she\"/>\n    <substitute find=\" he \" replace=\"I\"/>\n    <substitute find=\" she \" replace=\"I\"/>\n    <substitute find=\" me \" replace=\"him or her\"/>\n    <substitute find=\" him \" replace=\"me\"/>\n    <substitute find=\" her \" replace=\"me\"/>\n    <substitute find=\" my \" replace=\"his or her\"/>\n    <substitute find=\" myself \" replace=\"him or herself\"/>\n    <substitute find=\" mine \" replace=\"his or hers\"/>\n  </person>\n  <person2>\n    <substitute find=\" with you \" replace=\"with me\"/>\n    <substitute find=\" with me \" replace=\"with you\"/>\n    <substitute find=\" to you \" replace=\"to me\"/>\n    <substitute find=\" to me \" replace=\"to you\"/>\n    <substitute find=\" of you \" replace=\"of me\"/>\n    <substitute find=\" of me \" replace=\"of you\"/>\n    <substitute find=\" for you \" replace=\"for me\"/>\n    <substitute find=\" for me \" replace=\"for you\"/>\n    <substitute find=\" give you \" replace=\"give me\"/>\n    <substitute find=\" give me \" replace=\"give you\"/>\n    <substitute find=\" giving you \" replace=\"giving me\"/>\n    <substitute find=\" giving me \" replace=\"giving you\"/>\n    <substitute find=\" gave you \" replace=\"gave me\"/>\n    <substitute find=\" gave me \" replace=\"gave you\"/>\n    <substitute find=\" make you \" replace=\"make me\"/>\n    <substitute find=\" make me \" replace=\"make you\"/>\n    <substitute find=\" made you \" replace=\"made me\"/>\n    <substitute find=\" made me \" replace=\"made you\"/>\n    <substitute find=\" take you \" replace=\"take me\"/>\n    <substitute find=\" take me \" replace=\"take you\"/>\n    <substitute find=\" save you \" replace=\"save me\"/>\n    <substitute find=\" save me \" replace=\"save you\"/>\n    <substitute find=\" tell you \" replace=\"tell me\"/>\n    <substitute find=\" tell me \" replace=\"tell you\"/>\n    <substitute find=\" telling you \" replace=\"telling me\"/>\n    <substitute find=\" telling me \" replace=\"telling you\"/>\n    <substitute find=\" told you \" replace=\"told me\"/>\n    <substitute find=\" told me \" replace=\"told you\"/>\n    <substitute find=\" are you \" replace=\"am I\"/>\n    <substitute find=\" am I \" replace=\"are you\"/>\n    <substitute find=\" you are \" replace=\"I am\"/>\n    <substitute find=\" I am \" replace=\"you are\"/>\n    <substitute find=\" you will \" replace=\"I will\"/>\n    <substitute find=\" you \" replace=\"me\"/>\n    <substitute find=\" me \" replace=\"you\"/>\n    <substitute find=\" your \" replace=\"my\"/>\n    <substitute find=\" my \" replace=\"your\"/>\n    <substitute find=\" yours \" replace=\"mine\"/>\n    <substitute find=\" mine \" replace=\"yours\"/>\n    <substitute find=\" yourself \" replace=\"myself\"/>\n    <substitute find=\" myself \" replace=\"yourself\"/>\n    <substitute find=\" I was \" replace=\"you were\"/>\n    <substitute find=\" you were \" replace=\"I was\"/>\n    <substitute find=\" I am \" replace=\"you are\"/>\n    <substitute find=\" you are \" replace=\"I am\"/>\n    <substitute find=\" I \" replace=\"you\"/>\n    <substitute find=\" me \" replace=\"you\"/>\n    <substitute find=\" my \" replace=\"your\"/>\n    <substitute find=\" your \" replace=\"my\"/>\n  </person2>\n</substitutions>";

    public static String getConfigFileLocation(Context context, int mode) {
        File dirFile;
        String dirPath = "";
        File filesDir = context.getFilesDir();
        if (filesDir != null && !(dirFile = new File(dirPath = filesDir.getAbsolutePath() + "/AIHelp/bot")).exists() && dirFile.mkdirs()) {
            return dirFile.getAbsolutePath() + File.separator + ConfigUtil.getConfigFileName(mode);
        }
        return dirPath + File.separator + ConfigUtil.getConfigFileName(mode);
    }

    private static String getConfigFileName(int mode) {
        String fileName = "";
        switch (mode) {
            case 1004: {
                fileName = "context.xml";
                break;
            }
            case 1005: {
                fileName = "splitters.xml";
                break;
            }
            case 1006: {
                fileName = "substitutions.xml";
            }
        }
        return fileName;
    }

    private static void prepareElvaBotConfigs(Context context, int mode, String content) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(ConfigUtil.getConfigFileLocation(context, mode)));
            fos.write(content.getBytes());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void prepareElvaBotConfigs(Context context) {
        ConfigUtil.prepareElvaBotConfigs(context, 1004, AIBotContextStr);
        ConfigUtil.prepareElvaBotConfigs(context, 1005, AIBotSplittersStr);
        ConfigUtil.prepareElvaBotConfigs(context, 1006, AIBotSubstitutionsStr);
    }
}

