/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.logic.common.RequestRetryHandler;
import net.aihelp.data.model.init.InitEntity;
import net.aihelp.data.track.resource.ResourceTracker;
import net.aihelp.ui.helper.MessageSyncHelper;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.SpUtil;
import org.json.JSONObject;

public class InitHelper
implements RequestRetryHandler.OnRetryRequestListener {
    public static final int ERROR_INVALID_APP_ID = 4100;
    private static InitHelper sInstance;
    private final RequestRetryHandler mRetryHandler = new RequestRetryHandler(this, 5);
    private boolean requireCallback;
    private InitEntity initEntity;

    private InitHelper() {
    }

    public static InitHelper getInstance() {
        if (sInstance == null) {
            sInstance = new InitHelper();
        }
        return sInstance;
    }

    public InitEntity getInitEntity() {
        return this.initEntity;
    }

    public void runInitRelatedTask(final Context context) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                InitHelper.this.goLogDauStatus(context);
                InitHelper.this.requestInit(true);
                MessageSyncHelper.syncLogMessage();
            }
        });
    }

    public void onAIHelpInitializedCallback(final boolean isSuccess, final String message) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                AIHelpContext.successfullyInit.set(isSuccess);
                if (InitHelper.this.requireCallback && Const.sInitializedListener != null) {
                    Const.sInitializedListener.onAIHelpInitialized(isSuccess, message);
                    Const.sInitializedListener = null;
                }
            }
        }, 200L);
    }

    private void goLogDauStatus(Context context) {
        long initTime = SpUtil.getInstance().getLong("sp_log_dau_time");
        if (!DateFormatUtil.isToday(initTime)) {
            try {
                JSONObject dauParams = new JSONObject();
                dauParams.put("deviceid", (Object)DeviceUuidFactory.id(context));
                AIHelpRequest.getInstance().requestPostByJson(API.LOG_DAU_URL, dauParams, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        SpUtil.getInstance().put("sp_log_dau_time", System.currentTimeMillis());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void requestInit(boolean requireCallback) {
        this.requireCallback = requireCallback;
        String spPrefix = String.format("%s_%s_%s", Const.APP_ID, Const.ORIGINAL_LANGUAGE, "4.6.0");
        final long lastInitTime = SpUtil.getInstance().getLong(spPrefix + "init_timestamp", System.currentTimeMillis());
        int requestLimit = SpUtil.getInstance().getInt(spPrefix + "init_limit");
        final String cachedInitData = SpUtil.getInstance().getString(spPrefix + "init_response");
        LocalizeHelper.resetLocalizeData();
        if (TextUtils.isEmpty((CharSequence)cachedInitData) || requestLimit < 0 || System.currentTimeMillis() - lastInitTime > (long)requestLimit) {
            ResourceTracker.markInitStarted();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("domain", (Object)API.HOST_URL);
                AIHelpRequest.getInstance().requestGetByAsync(API.INIT_URL, jsonObject, new ReqCallback<String>(){

                    @Override
                    public void onAsyncReqSuccess(String result) {
                        if (InitHelper.this.mRetryHandler != null) {
                            InitHelper.this.mRetryHandler.removeCallbacksAndMessages(null);
                        }
                        InitHelper.this.cacheInitResponse(result, System.currentTimeMillis());
                    }

                    @Override
                    public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                        switch (errorCode) {
                            case 4100: {
                                InitHelper.this.onAIHelpInitializedCallback(false, "Invalid init parameters");
                                break;
                            }
                            default: {
                                ResourceTracker.markInitEnded(false);
                                if (TextUtils.isEmpty((CharSequence)cachedInitData)) {
                                    if (InitHelper.this.mRetryHandler == null) break;
                                    InitHelper.this.mRetryHandler.handleRetryRequest(errorCode, errorMsg);
                                    break;
                                }
                                InitHelper.this.cacheInitResponse(cachedInitData, lastInitTime);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.cacheInitResponse(cachedInitData, lastInitTime);
        }
    }

    private void cacheInitResponse(String initResponse, long lastInitTime) {
        this.initEntity = JsonHelper.toJavaObject(initResponse, InitEntity.class);
        if (this.initEntity != null) {
            String[] faqMqtt;
            int cachePeriod = this.initEntity.getRequestLimit();
            String spPrefix = String.format("%s_%s_%s", Const.APP_ID, Const.ORIGINAL_LANGUAGE, "4.6.0");
            SpUtil.getInstance().put(spPrefix + "init_limit", cachePeriod < 0 ? cachePeriod : cachePeriod * 60 * 1000);
            SpUtil.getInstance().put(spPrefix + "init_response", initResponse);
            SpUtil.getInstance().put(spPrefix + "init_timestamp", lastInitTime);
            API.CDN_URL = this.initEntity.getCdnUrl();
            API.FAQ_URL = this.initEntity.getFaqdata();
            API.OP_URL = this.initEntity.getFaqYYdata();
            API.UPLOAD_IMAGE_URL = this.initEntity.getUpload();
            API.UPLOAD_VIDEO_URL = this.initEntity.getUploadVideo();
            API.UPLOAD_LOG_URL = this.initEntity.getUploadLog();
            API.UPLOAD_ATTACHMENT_URL = this.initEntity.getUploadFile();
            API.M_FAQ_URL = this.initEntity.getShowfaq();
            API.LOG_COUNT_URL = this.initEntity.getPoint();
            API.CONFIG_INIT_LOCALE_FILE = this.initEntity.getLocaleFile();
            API.CONFIG_INIT_UPLOAD_LIMIT = this.initEntity.getSdkCustomUpload();
            API.MQTT_IP = this.initEntity.getSvrip();
            API.MQTT_PORT = this.initEntity.getSvrport();
            API.MQTT_TOPIC = this.initEntity.getTopic();
            if (!TextUtils.isEmpty((CharSequence)this.initEntity.getPushServer()) && (faqMqtt = this.initEntity.getPushServer().split(":")).length == 2) {
                API.MQTT_FAQ_IP = faqMqtt[0];
                API.MQTT_FAQ_PORT = faqMqtt[1];
            }
            Const.TOGGLE_UPLOAD_VIDEO = this.initEntity.isOpenVideoUpload();
            Const.TOGGLE_CRM_TOKEN = this.initEntity.isSetCrmToken();
            Const.TOGGLE_OPEN_FAQ_NOTIFICATION = this.initEntity.isOpenPushServer();
            Const.TOGGLE_OPEN_UNREAD_MSG = this.initEntity.isUnreadMessage();
            Const.TOGGLE_UPLOAD_LOG = this.initEntity.isOpenUploadLogFile();
            Const.TOGGLE_LOCALIZE_VIA_INIT = this.initEntity.isLocalizeFAQViaInit();
            Const.TOGGLE_MQTT_TLS = this.initEntity.isTls();
            Const.TOGGLE_TRANSLATE_CS_MESSAGE = this.initEntity.isTranslates();
            Const.TOGGLE_DISTINGUISH_USER_BY_DEVICE = this.initEntity.isDistinguishUserByDevice();
            Const.TOGGLE_HIDE_BRAND = this.initEntity.isHideBrand();
            Const.FAQ_FILE = this.initEntity.getFaqFileName();
            Const.LIMIT_CHECKING_UNREAD = this.initEntity.getUnreadMessageTime();
            API.CONFIG_RPA_PREDICTION = this.initEntity.getAibotQuestion();
            if (!TextUtils.isEmpty((CharSequence)this.initEntity.getCorrectLanguage())) {
                Const.CORRECT_LANGUAGE = this.initEntity.getCorrectLanguage();
            }
            if (this.initEntity.getNetworkCheckSetting() != null) {
                Const.TOGGLE_NET_CHECK = true;
                Const.NET_TRACE_ROUTE = this.initEntity.getNetworkCheckSetting().getTraceroute();
                Const.NET_PING = this.initEntity.getNetworkCheckSetting().getPing();
            }
            if (this.initEntity.getSdkCustomConfig() != null) {
                InitEntity.SdkCustomConfigEntity sdkCustomConfig = this.initEntity.getSdkCustomConfig();
                API.CONFIG_INIT_PROCESS = sdkCustomConfig.getProcess();
                API.CONFIG_INIT_TEXT = sdkCustomConfig.getText();
                API.CONFIG_INIT_BUSINESS_LOGIC = sdkCustomConfig.getGeneral();
            }
            Const.LIMIT_PROACTIVE_FETCH = this.initEntity.getFetchFrequency();
            API.SAMPLING_FILTER = this.initEntity.getSdkSamplingFile();
            API.UPLOAD_SAMPLING_URL = this.initEntity.getUploadSamplingUrl();
            ResourceTracker.markInitEnded(true);
            LocalizeHelper.goFetchLocalizeData(1);
            if (this.requireCallback) {
                Log.e((String)"AIHelp", (String)"AIHelp is now ready to help you have conversations with your users!");
            }
        }
    }

    @Override
    public void onRetryRequest() {
        this.requestInit(true);
    }

    @Override
    public void onRetryUpToMaxCount(int code, String errorMsg) {
        this.onAIHelpInitializedCallback(false, errorMsg);
    }
}

