/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Window;
import android.webkit.JavascriptInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import java.lang.ref.WeakReference;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.ui.BaseActivity;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.request.animation.GlideAnimation;
import net.aihelp.core.ui.glide.request.target.SimpleTarget;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.TemplateReadyEvent;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.SupportFragment;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class HostActivity
extends BaseActivity {
    private static WeakReference<Window> sPhoneWindow;
    FragmentManager fragmentManager;

    public static Window getHostWindow() {
        if (sPhoneWindow != null && sPhoneWindow.get() != null) {
            return (Window)sPhoneWindow.get();
        }
        return null;
    }

    @Override
    public int getLayoutId() {
        return ResResolver.getLayoutId("aihelp_act_host");
    }

    @Override
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.watchLeakCanary();
        if (Const.sSessionOpenListener != null) {
            Const.sSessionOpenListener.onAIHelpSessionOpened();
        }
        sPhoneWindow = new WeakReference<Window>(this.getWindow());
        Const.IS_SDK_SHOWING = true;
        this.getWindow().setFlags(0x1000000, 0x1000000);
        super.onCreate(savedInstanceState);
        this.updateWindowConfiguration();
        EventTracker.INSTANCE.log(400, new Object[0]);
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    private void updateWindowConfiguration() {
        switch (CustomConfig.InitSetting.screenOrientation) {
            case 1: {
                CustomConfig.InitSetting.isLandscape = true;
                this.setRequestedOrientation(6);
                break;
            }
            case 2: {
                CustomConfig.InitSetting.isLandscape = false;
                this.setRequestedOrientation(1);
                break;
            }
            case 3: {
                CustomConfig.InitSetting.isLandscape = this.getResources().getConfiguration().orientation == 2;
                this.setRequestedOrientation(-1);
            }
        }
        if (CustomConfig.CommonSetting.isBackgroundRenderedWithImage) {
            this.updateWindowBackgroundImage();
        } else {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(Styles.getColor(CustomConfig.CommonSetting.backgroundColorForAll)));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().clearFlags(0x4000000);
            this.getWindow().addFlags(Integer.MIN_VALUE);
            this.getWindow().setStatusBarColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
            if (Build.VERSION.SDK_INT >= 23) {
                this.getWindow().getDecorView().setSystemUiVisibility(Styles.isLightColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor)) ? 0 : 8192);
            }
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (CustomConfig.InitSetting.screenOrientation == 3) {
            CustomConfig.InitSetting.isLandscape = newConfig.orientation == 2;
            EventBus.getDefault().post(new OrientationChangeEvent((Integer)newConfig.orientation));
            if (CustomConfig.CommonSetting.isBackgroundRenderedWithImage) {
                this.updateWindowBackgroundImage();
            }
        }
    }

    private void updateWindowBackgroundImage() {
        String resource = Styles.isLandscape() ? CustomConfig.CommonSetting.backgroundImageForLandscape : CustomConfig.CommonSetting.backgroundImageForPortrait;
        if (!TextUtils.isEmpty((CharSequence)resource)) {
            Glide.with(this.getApplicationContext()).load(resource).asBitmap().into(new SimpleTarget<Bitmap>(){

                @Override
                public void onResourceReady(Bitmap bitmap, GlideAnimation<? super Bitmap> glideAnimation) {
                    HostActivity.this.getWindow().setBackgroundDrawable((Drawable)new BitmapDrawable(HostActivity.this.getResources(), bitmap));
                }
            });
        }
    }

    @Override
    public void initView() {
        this.fragmentManager = this.getSupportFragmentManager();
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        FragmentTransaction fraTransaction = this.fragmentManager.beginTransaction();
        fraTransaction.add(ResResolver.getViewId("aihelp_root_container"), (Fragment)SupportFragment.getInstance(bundle));
        fraTransaction.commit();
    }

    @JavascriptInterface
    public void finishFormPage() {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HostActivity.this.onBackPressed();
            }
        });
    }

    @JavascriptInterface
    public void onFormSubmitted() {
        TicketStatusTracker.isTicketActive = true;
        AIHelpRequest.getInstance().requestPostByJson(API.LOGOUT, "", null);
    }

    private void watchLeakCanary() {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onTemplateReady(TemplateReadyEvent templateReadyEvent) {
        this.updateWindowConfiguration();
    }

    public void onBackPressed() {
        List fragments = this.fragmentManager.getFragments();
        for (Fragment fragment : fragments) {
            if (fragment == null || !fragment.isVisible() || !(fragment instanceof SupportFragment)) continue;
            if (((SupportFragment)fragment).onBackPressed()) {
                FragmentManager childFragmentManager = fragment.getChildFragmentManager();
                if (childFragmentManager.getBackStackEntryCount() <= 0) continue;
                childFragmentManager.popBackStack();
                return;
            }
            return;
        }
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Const.IS_SDK_SHOWING = false;
        if (Const.sSessionCloseListener != null) {
            Const.sSessionCloseListener.onAIHelpSessionClosed();
        }
        EventTracker.INSTANCE.log(401, new Object[0]);
        StatisticTracker.getInstance().calculateDurationInAIHelp();
        AIHelpPermissions.getInstance().recycle();
        sPhoneWindow = null;
    }
}

