/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.ui.ActivityManager;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.FatalErrorEvent;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.SupportHelper;
import net.aihelp.ui.widget.AIHelpFakeSearch;
import net.aihelp.ui.widget.AIHelpSearchView;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SupportFragment
extends BaseFragment
implements View.OnClickListener,
IFaqParentView {
    private SupportHelper mSupportHelper;
    private ImageView ivBack;
    private ImageView ivLoading;
    private ImageView ivTitle;
    private TextView tvTitle;
    private AIHelpSearchView searchView;
    private TextView tvLogo;
    private LinearLayout fakeSearchPort;
    private AIHelpFakeSearch fakeSearchLand;
    private ObjectAnimator loadingAnimator;

    public static SupportFragment getInstance(Bundle bundle) {
        SupportFragment fraSupport = new SupportFragment();
        fraSupport.setArguments(bundle);
        return fraSupport;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.mSupportHelper == null) {
            this.mSupportHelper = new SupportHelper(context, this.getRetainedChildFragmentManager(), this.getArguments());
        }
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
        this.ivBack = (AppCompatImageView)this.get("aihelp_iv_back");
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(this.ivBack, "aihelp_svg_ic_back", true);
        this.tvLogo = (TextView)this.get("aihelp_logo");
        this.tvLogo.setVisibility(Const.TOGGLE_HIDE_BRAND ? 8 : 0);
        this.ivLoading = (AppCompatImageView)this.get("aihelp_iv_loading");
        this.ivTitle = (ImageView)this.get("aihelp_iv_title");
        this.tvTitle = (TextView)this.get("aihelp_tv_title");
        this.searchView = (AIHelpSearchView)((Object)this.get("aihelp_search_view"));
        this.fakeSearchPort = (LinearLayout)this.get("aihelp_fake_search_port");
        this.fakeSearchLand = (AIHelpFakeSearch)((Object)this.get("aihelp_fake_search_land"));
        this.ivLoading = (AppCompatImageView)this.get("aihelp_iv_loading");
        this.loadingAnimator = ObjectAnimator.ofFloat((Object)this.ivLoading, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.loadingAnimator.setDuration(1000L);
        this.loadingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.loadingAnimator.setRepeatCount(-1);
    }

    @Override
    protected void initEventAndData(View view) {
        RelativeLayout rlNavigation = (RelativeLayout)this.get("aihelp_rl_navigation");
        rlNavigation.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        this.ivLoading = (AppCompatImageView)this.get("aihelp_iv_loading");
        this.ivTitle = (ImageView)this.get("aihelp_iv_title");
        this.tvTitle = (TextView)this.get("aihelp_tv_title");
        this.searchView = (AIHelpSearchView)((Object)this.get("aihelp_search_view"));
        this.fakeSearchPort = (LinearLayout)this.get("aihelp_fake_search_port");
        this.fakeSearchPort.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        this.fakeSearchLand = (AIHelpFakeSearch)((Object)this.get("aihelp_fake_search_land"));
        Styles.reRenderImageView(this.ivLoading, "aihelp_svg_ic_loading");
        BreakReleaseHelper releaseBreaker = new BreakReleaseHelper();
        this.tvTitle.setOnClickListener((View.OnClickListener)releaseBreaker);
        this.tvTitle.setOnLongClickListener((View.OnLongClickListener)releaseBreaker);
        this.tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
        this.tvTitle.setMaxWidth(Styles.getScreenWidth(this.tvTitle.getContext()) / 2);
        this.fakeSearchPort.setOnClickListener((View.OnClickListener)this);
        this.fakeSearchLand.setOnClickListener(this);
        this.updateTitleBarAccordingToSearchStatus(false);
        this.tvLogo = (TextView)this.get("aihelp_logo");
        this.tvLogo.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 1.0));
        this.tvLogo.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));
        this.searchView.setupSearchView(new AIHelpSearchView.OnAIHelpSearchViewListener(){

            @Override
            public void onFocusChanged() {
            }

            @Override
            public void onInputCanceled() {
                FragmentManager childFragmentManager = SupportFragment.this.getChildFragmentManager();
                if (childFragmentManager.getBackStackEntryCount() > 0) {
                    childFragmentManager.popBackStack();
                }
                SupportFragment.this.updateTitleBarAccordingToSearchStatus(false);
            }
        }, this.getFaqEventListener());
        this.mSupportHelper.start();
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_support");
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void onEventComing(EventCenter event) {
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(this.getRetainedChildFragmentManager());
        if (event instanceof LoadingElvaEvent) {
            if (event.getCode() == 1003) {
                if (this.loadingAnimator.isRunning() || !this.shouldShowLoading(topMostFragment)) {
                    return;
                }
                this.ivLoading.setVisibility(0);
                this.loadingAnimator.start();
            } else {
                this.ivLoading.setVisibility(8);
                this.loadingAnimator.cancel();
            }
        }
        if (event instanceof PageHoppingEvent && event.getCode() == 1009) {
            this.mSupportHelper.onIntentToFillForm((Bundle)((PageHoppingEvent)event).getEvent(), true);
        }
        if (event instanceof UpdateTitleEvent) {
            UpdateTitleEvent updateTitleEvent;
            if (this.tvLogo != null) {
                boolean showBranding = !Const.TOGGLE_HIDE_BRAND && !(topMostFragment instanceof BaseCSFragment);
                this.tvLogo.setVisibility(showBranding ? 0 : 8);
            }
            if ((updateTitleEvent = (UpdateTitleEvent)event).getIcon() != null) {
                boolean showCsTitleIcon = topMostFragment instanceof BaseCSFragment && CustomConfig.CustomerService.isCsTitleIconVisible;
                boolean showFaqTitleIcon = topMostFragment instanceof BaseFaqFragment && CustomConfig.HelpCenter.isFaqTitleIconVisible;
                Styles.loadIcon(this.ivTitle, updateTitleEvent.getIcon(), showCsTitleIcon || showFaqTitleIcon);
            }
            if (updateTitleEvent.getTitle() != null) {
                Styles.reRenderTextView(this.tvTitle, updateTitleEvent.getTitle());
            }
        }
        if (event instanceof SearchViewVisibilityChangeEvent) {
            boolean shouldShowSearchView = (Boolean)event.getEvent();
            this.updateTitleBarAccordingToSearchStatus(shouldShowSearchView);
        }
        if (event instanceof OrientationChangeEvent) {
            this.tvTitle.setMaxWidth(Styles.getScreenWidth(this.tvTitle.getContext()) / 2);
            boolean isRealSearchVisibleNow = topMostFragment instanceof FaqSearchFragment;
            this.updateTitleBarAccordingToSearchStatus(isRealSearchVisibleNow);
        }
        if (event instanceof FatalErrorEvent && this.getActivity() != null && !this.getActivity().isFinishing()) {
            Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)"Oops! Something went wrong", (int)0).show();
            AIHelpMqtt.getInstance().onFaqDestroy();
            AIHelpMqtt.getInstance().disconnect();
            Const.IS_SDK_SHOWING = false;
            ActivityManager.INSTANCE.finishAll();
        }
    }

    private boolean shouldShowLoading(Fragment topFragment) {
        if (topFragment != null) {
            String topName = topFragment.getClass().getSimpleName();
            return CustomerServiceFragment.class.getSimpleName().equals(topName);
        }
        return false;
    }

    public boolean onBackPressed() {
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(this.getRetainedChildFragmentManager());
        if (topMostFragment == null) {
            return true;
        }
        String topName = topMostFragment.getClass().getSimpleName();
        if (FaqContentFragment.class.getSimpleName().equals(topName)) {
            return ((FaqContentFragment)topMostFragment).onBackPressed();
        }
        if (IntentUrlFragment.class.getSimpleName().equals(topName)) {
            return ((IntentUrlFragment)topMostFragment).onBackPressed();
        }
        if (FaqSearchFragment.class.getSimpleName().equals(topName)) {
            SoftInputUtil.hideSoftInput(this.getContext(), (View)this.searchView);
        }
        return true;
    }

    public void onClick(View v) {
        if (FastClickValidator.validate(0.5f) && Const.isNestedFragmentOnResume) {
            if (v.getId() == ResResolver.getViewId("aihelp_iv_back") && this.getActivity() != null) {
                this.getActivity().onBackPressed();
            }
            if (v.getId() == ResResolver.getViewId("aihelp_fake_search_port") || v.getId() == ResResolver.getViewId("aihelp_fake_search_land")) {
                this.mSupportHelper.onIntentToSearch(this.getArguments());
                this.searchView.autoFocus();
                StatisticTracker.getInstance().clickSearch();
            }
        }
    }

    private void updateTitleBarAccordingToSearchStatus(boolean showRealSearch) {
        ViewGroup viewGroup = (ViewGroup)this.ivTitle.getParent();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)viewGroup.getLayoutParams();
        Fragment topFragment = FragmentHelper.getTopMostFragment(this.getRetainedChildFragmentManager());
        if (topFragment instanceof BaseFaqFragment) {
            this.ivTitle.setVisibility(CustomConfig.HelpCenter.isFaqTitleIconVisible && !showRealSearch ? 0 : 8);
            this.tvTitle.setVisibility(!showRealSearch ? 0 : 8);
            if (CustomConfig.HelpCenter.isFaqSearchVisible) {
                boolean isFaqHome = FaqHomeFragment.class.getName().equals(topFragment.getClass().getName());
                this.fakeSearchPort.setVisibility(isFaqHome && !Styles.isLandscape() && !showRealSearch ? 0 : 8);
                this.fakeSearchLand.setVisibility(isFaqHome && Styles.isLandscape() && !showRealSearch ? 0 : 8);
                this.searchView.setVisibility(showRealSearch ? 0 : 8);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams.addRule(17, ResResolver.getViewId("aihelp_iv_back"));
                layoutParams.addRule(1, ResResolver.getViewId("aihelp_iv_back"));
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        if (topFragment instanceof BaseCSFragment) {
            this.ivTitle.setVisibility(CustomConfig.CustomerService.isCsTitleIconVisible ? 0 : 8);
            this.tvTitle.setVisibility(0);
            this.fakeSearchPort.setVisibility(8);
            this.fakeSearchLand.setVisibility(8);
            this.searchView.setVisibility(8);
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams.removeRule(1);
                layoutParams.removeRule(17);
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_support_fragment_container");
    }

    @Override
    public IFaqEventListener getFaqEventListener() {
        return this.mSupportHelper;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.loadingAnimator != null) {
            this.loadingAnimator.cancel();
            this.loadingAnimator = null;
        }
        AIHelpMqtt.getInstance().onFaqDestroy();
    }
}

