/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter;

import android.content.Context;
import androidx.fragment.app.Fragment;
import java.util.Iterator;
import java.util.List;
import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.cs.agent.AgentAnswerAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentFaqAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentFileAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentImageAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentRichTextAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentTextAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentVideoAdapter;
import net.aihelp.ui.adapter.cs.other.ErrorBoundaryAdapter;
import net.aihelp.ui.adapter.cs.other.LoadingAdapter;
import net.aihelp.ui.adapter.cs.other.TimeMsgAdapter;
import net.aihelp.ui.adapter.cs.user.UserEvaluateFaqAdapter;
import net.aihelp.ui.adapter.cs.user.UserEvaluationAdapter;
import net.aihelp.ui.adapter.cs.user.UserFileAdapter;
import net.aihelp.ui.adapter.cs.user.UserImageAdapter;
import net.aihelp.ui.adapter.cs.user.UserTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserVideoAdapter;
import net.aihelp.utils.ListUtil;

public class MessageListAdapter
extends MultiItemTypeAdapter<Message> {
    private StringBuilder timestampTracker = new StringBuilder();
    private final AgentTextAdapter adminAdapter;
    private final AgentFaqAdapter agentFaqAdapter;
    private final AgentAnswerAdapter answerFaqAdapter;
    private final AgentRichTextAdapter agentRichTextAdapter;
    private final UserTextAdapter userAdapter;
    private final UserImageAdapter userImageAdapter;
    private final UserVideoAdapter userVideoAdapter;
    private final UserFileAdapter userFileAdapter;

    public MessageListAdapter(Context context, Fragment fragment) {
        super(context);
        this.adminAdapter = new AgentTextAdapter(context);
        this.addItemViewDelegate(this.adminAdapter);
        this.agentRichTextAdapter = new AgentRichTextAdapter(context, fragment);
        this.addItemViewDelegate(this.agentRichTextAdapter);
        this.agentFaqAdapter = new AgentFaqAdapter(context);
        this.addItemViewDelegate(this.agentFaqAdapter);
        this.answerFaqAdapter = new AgentAnswerAdapter(context);
        this.addItemViewDelegate(this.answerFaqAdapter);
        this.addItemViewDelegate(new AgentImageAdapter(context, fragment));
        this.addItemViewDelegate(new AgentVideoAdapter(context, fragment));
        this.addItemViewDelegate(new AgentFileAdapter(context, fragment));
        this.userAdapter = new UserTextAdapter(context);
        this.addItemViewDelegate(this.userAdapter);
        this.userImageAdapter = new UserImageAdapter(context, fragment);
        this.addItemViewDelegate(this.userImageAdapter);
        this.userVideoAdapter = new UserVideoAdapter(context, fragment);
        this.addItemViewDelegate(this.userVideoAdapter);
        this.addItemViewDelegate(new UserEvaluateFaqAdapter(context));
        this.userFileAdapter = new UserFileAdapter(context, fragment);
        this.addItemViewDelegate(this.userFileAdapter);
        this.addItemViewDelegate(new UserEvaluationAdapter(context));
        this.addItemViewDelegate(new TimeMsgAdapter(context));
        this.addItemViewDelegate(new LoadingAdapter(context));
        this.addItemViewDelegate(-1, new ErrorBoundaryAdapter(context));
    }

    public void insertHistoryConversation(List<Message> msgList) {
        this.mDatas.addAll(0, msgList);
        this.notifyDataSetChanged();
    }

    public void updateAgentTypingStatus(boolean visible) {
        if (visible) {
            this.update(Message.getAgentTypingMsg());
        } else {
            for (int i = this.getItemCount() - 1; i >= 0; --i) {
                Message msg = (Message)this.mDatas.get(i);
                if (msg.getMsgType() != 2) continue;
                StatisticTracker.getInstance().calculateDurationForWaiting();
                this.remove(i);
                break;
            }
        }
    }

    @Override
    public void update(Message message) {
        if (this.isMessageAlreadyInserted(message)) {
            return;
        }
        super.update(message);
    }

    @Override
    public void update(List<Message> dataList, Boolean isClear) {
        if (ListUtil.isListEmpty(dataList)) {
            return;
        }
        if (isClear.booleanValue()) {
            this.timestampTracker = new StringBuilder();
        }
        Iterator<Message> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (!this.isMessageAlreadyInserted(message)) continue;
            iterator.remove();
        }
        super.update(dataList, isClear);
    }

    private boolean isMessageAlreadyInserted(Message message) {
        if (this.timestampTracker == null) {
            this.timestampTracker = new StringBuilder();
        }
        String timestamp = String.valueOf(message.getTimestamp());
        if (this.timestampTracker.toString().contains(timestamp)) {
            return true;
        }
        this.timestampTracker.append(String.format("%s,", timestamp));
        return false;
    }

    public void setOnClickedListener(OnClickedListenerWrapper mListener) {
        if (this.adminAdapter != null) {
            this.adminAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.agentRichTextAdapter != null) {
            this.agentRichTextAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.agentFaqAdapter != null) {
            this.agentFaqAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.answerFaqAdapter != null) {
            this.answerFaqAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userAdapter != null) {
            this.userAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userImageAdapter != null) {
            this.userImageAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userVideoAdapter != null) {
            this.userVideoAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userFileAdapter != null) {
            this.userFileAdapter.setOnClickedListenerWrapper(mListener);
        }
    }

    public static class OnClickedListenerWrapper
    implements OnTextClickedListener {
        @Override
        public void onUrlClicked(boolean isForm, String url) {
            if (isForm) {
                StatisticTracker.getInstance().onFormClicked(url);
            }
        }

        @Override
        public void onBotAnswerSelected(Message message) {
        }

        @Override
        public void onRetrySendingMessage(int position, Message msg) {
        }
    }

    private static interface OnTextClickedListener {
        public void onUrlClicked(boolean var1, String var2);

        public void onBotAnswerSelected(Message var1);

        public void onRetrySendingMessage(int var1, Message var2);
    }
}

