/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.config.IntentEntity;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class SmartIntentAdapter
extends CommonAdapter<IntentEntity> {
    private final OnIntentSelectedListener mListener;

    public SmartIntentAdapter(Context context, OnIntentSelectedListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected int itemLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_smart_intent");
    }

    @Override
    protected void convert(ViewHolder holder, final IntentEntity intentEntity, int position) {
        TextView tvTitle = (TextView)holder.getView(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, intentEntity.getIntentName());
        final boolean hasNext = !ListUtil.isListEmpty(intentEntity.getIntentList());
        holder.setVisible(ResResolver.getViewId("aihelp_iv_next"), hasNext);
        holder.getConvertView().setBackground((Drawable)Styles.getClickableDrawableForList());
        holder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SmartIntentAdapter.this.mListener != null) {
                    SmartIntentAdapter.this.mListener.onIntentSelected(intentEntity, hasNext);
                }
            }
        });
    }

    public static interface OnIntentSelectedListener {
        public void onIntentSelected(IntentEntity var1, boolean var2);
    }
}

