/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import java.io.File;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.agent.AgentRichMessage;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.agent.AgentFileAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AgentRichTextAdapter
extends AgentFileAdapter {
    public AgentRichTextAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 8;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        LinearLayout llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_agent_message_container"));
        llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
        llContainer.removeAllViews();
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");
        Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_nickname")), message.getNickname(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)message.getNickname()), 13);
        this.convertSupportTextMsg(holder, (ViewGroup)llContainer, message);
    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, Message message) {
        holder.setVisible(this.getViewId("aihelp_tv_nickname"), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty((CharSequence)message.getNickname()));
        holder.setTextColor(this.getViewId("aihelp_tv_nickname"), Color.parseColor((String)CustomConfig.CommonSetting.textColor));
        container.addView(this.getRichTextMsg(message));
    }

    protected View getRichTextMsg(Message message) {
        AgentRichMessage richMessage;
        List<Message> messageList;
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(1);
        layout.setGravity(0x800003);
        layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        if (message instanceof AgentRichMessage && !ListUtil.isListEmpty(messageList = (richMessage = (AgentRichMessage)message).getMessageList())) {
            for (Message msg : messageList) {
                switch (msg.getMsgType()) {
                    case 3: {
                        layout.addView(this.getTextViewFromRichText(msg.getContent()));
                        break;
                    }
                    case 6: {
                        layout.addView(this.getImageViewFromRichText(msg.getContent()));
                        break;
                    }
                    case 7: {
                        layout.addView(this.getVideoViewFromRichText(msg.getContent()));
                        break;
                    }
                    case 9: {
                        layout.addView(this.getAttachmentViewFromRichText(msg));
                    }
                }
            }
        }
        return layout;
    }

    private View getImageViewFromRichText(final String imageUrl) {
        ImageView imageView = new ImageView(this.mContext);
        ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        layoutParams.topMargin = Styles.dpToPx(this.mContext, 3.0f);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setAdjustViewBounds(true);
        MediaUtils.scaleImageView(imageUrl, imageView, (View)imageView, null);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.startAct(AgentRichTextAdapter.this.mFragment, PreviewInfo.get(imageUrl));
            }
        });
        return imageView;
    }

    private View getVideoViewFromRichText(final String videoUrl) {
        final View rootView = View.inflate((Context)this.mContext, (int)ResResolver.getLayoutId("aihelp_loading_image_view"), null);
        final ImageView imageView = (ImageView)rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        final ImageView ivPlay = (ImageView)rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        final View maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        final View loadingView = rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        rootView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.dip2px(this.mContext, 120.0), this.dip2px(this.mContext, 150.0)));
        MediaUtils.getImageForVideo(videoUrl, new MediaUtils.OnLoadVideoImageListener(){

            @Override
            public void onLoadImage(File file) {
                MediaUtils.scaleImageView(file.getAbsolutePath(), imageView, rootView, new MediaUtils.OnImageScaledListener(){

                    @Override
                    public void onImageScaled() {
                        maskView.setVisibility(8);
                        loadingView.setVisibility(8);
                        ivPlay.setVisibility(0);
                    }
                });
                rootView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PreviewActivity.startAct(AgentRichTextAdapter.this.mFragment, PreviewInfo.get(videoUrl));
                    }
                });
            }
        });
        return rootView;
    }

    private View getAttachmentViewFromRichText(final Message message) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            View rootView = View.inflate((Context)this.mContext, (int)ResResolver.getLayoutId("aihelp_layout_rich_text_attachment"), null);
            rootView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                    PreviewActivity.startAct(AgentRichTextAdapter.this.mFragment, previewInfo);
                }
            });
            TextView tvFileName = (TextView)rootView.findViewById(ResResolver.getViewId("aihelp_tv_file_name"));
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            tvFileName.measure(0, 0);
            ViewGroup.LayoutParams tvFileNameLayoutParams = tvFileName.getLayoutParams();
            tvFileNameLayoutParams.width = Math.min(tvFileName.getMeasuredWidth(), super.getRightfulMaxWidthForFileName());
            tvFileName.setLayoutParams(tvFileNameLayoutParams);
            TextView tvFileSize = (TextView)rootView.findViewById(ResResolver.getViewId("aihelp_tv_file_size"));
            Styles.reRenderTextView(tvFileSize, fileMessage.getFileSize(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            ImageView ivFile = (ImageView)rootView.findViewById(this.getViewId("aihelp_iv_file"));
            this.renderImageViewWithFixedWidthAndHeight(ivFile, "aihelp_svg_ic_file", 36, 45);
            ImageView ivDownload = (ImageView)rootView.findViewById(this.getViewId("aihelp_iv_download"));
            this.renderImageViewWithFixedWidthAndHeight(ivDownload, "aihelp_svg_ic_download", 23, 20);
            ivDownload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(AgentRichTextAdapter.this.mContext, message.getContent());
                }
            });
            rootView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            return rootView;
        }
        return null;
    }

    private View getTextViewFromRichText(String text) {
        TextView textView = this.getMsg(text, true);
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        return textView;
    }
}

