/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageButton;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserEvaluateFaqAdapter
extends BaseMsgAdapter {
    public UserEvaluateFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_evaluate_faq");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 13;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
        ImageView ivUnHelpful = (ImageView)holder.getView(this.getViewId("aihelp_iv_un_helpful"));
        Styles.reRenderImageView(ivUnHelpful, "aihelp_svg_ic_un_helpful");
        ivUnHelpful.setVisibility(":aihelp-faq-unhelpful:".equals(message.getContent()) ? 0 : 8);
        ImageView ivHelpful = (ImageView)holder.getView(this.getViewId("aihelp_iv_helpful"));
        Styles.reRenderImageView(ivHelpful, "aihelp_svg_ic_helpful");
        ivHelpful.setVisibility(":aihelp-faq-helpful:".equals(message.getContent()) ? 0 : 8);
        AppCompatImageButton retryButton = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_msg_retry"));
        switch (message.getMsgStatus()) {
            case 1: 
            case 2: {
                retryButton.setVisibility(8);
                break;
            }
            case 3: {
                retryButton.setVisibility(0);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                retryButton.setOnClickListener(this.getRetryListener(position, message));
            }
        }
    }
}

