/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserEvaluationAdapter
extends BaseMsgAdapter {
    public UserEvaluationAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_evaluation");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 15;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        holder.setBackgroundDrawable(ResResolver.getViewId("aihelp_rl_container"), this.getUserBackgroundDrawable(this.isCurrentRtl));
        Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
        final AIHelpRatingBar ratingBar = (AIHelpRatingBar)((Object)holder.getView(ResResolver.getViewId("aihelp_rating_bar")));
        if (message instanceof UserMessage) {
            ratingBar.setCurrGrade(((UserMessage)message).getEvaluateGrade());
        }
        final TextView tvUserEvaluate = (TextView)holder.getView(ResResolver.getViewId("aihelp_tv_user_evaluate"));
        Styles.reRenderTextView(tvUserEvaluate, message.getContent(), -1, !TextUtils.isEmpty((CharSequence)message.getContent()), 14);
        tvUserEvaluate.post(new Runnable(){

            @Override
            public void run() {
                tvUserEvaluate.setMaxWidth(ratingBar.getMeasuredWidth());
            }
        });
        AppCompatImageButton retryButton = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_msg_retry"));
        switch (message.getMsgStatus()) {
            case 1: 
            case 2: {
                retryButton.setVisibility(8);
                break;
            }
            case 3: {
                retryButton.setVisibility(0);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                retryButton.setOnClickListener(this.getRetryListener(position, message));
            }
        }
    }

    private int getRightfulMaxWidth(ViewHolder holder) {
        ImageView ivPortrait = (ImageView)holder.getView(this.getViewId("aihelp_iv_portrait"));
        TextView tvMsg = (TextView)holder.getView(this.getViewId("aihelp_user_message_text"));
        return Styles.getScreenWidth(this.mContext) - (this.dip2px(this.mContext, 39.0) + ((ViewGroup.MarginLayoutParams)ivPortrait.getLayoutParams()).rightMargin + ((ViewGroup.MarginLayoutParams)tvMsg.getLayoutParams()).rightMargin) * 2;
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15) : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }
}

