/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.fragment.app.Fragment;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserFileAdapter
extends BaseMsgAdapter {
    public UserFileAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_file");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 14;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
            RelativeLayout rlContainer = (RelativeLayout)holder.getView(ResResolver.getViewId("aihelp_rl_file_container"));
            rlContainer.setBackground(this.getUserBackgroundDrawable(this.isCurrentRtl));
            rlContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (fileMessage.getMsgStatus() == 1) {
                        PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                        PreviewActivity.startAct(UserFileAdapter.this.mFragment, previewInfo);
                    }
                }
            });
            TextView tvFileName = (TextView)holder.getView(this.getViewId("aihelp_tv_file_name"));
            tvFileName.setMaxWidth(this.getRightfulMaxWidthForFileName());
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            Styles.reRenderTextView((TextView)holder.getView(this.getViewId("aihelp_tv_file_size")), fileMessage.getFileSize(), Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            Styles.reRenderImageView((ImageView)holder.getView(this.getViewId("aihelp_iv_file")), "aihelp_svg_ic_file", Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            Styles.reRenderImageView((ImageView)holder.getView(this.getViewId("aihelp_iv_download")), "aihelp_svg_ic_download", Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            holder.getView(ResResolver.getViewId("aihelp_iv_download")).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(UserFileAdapter.this.mContext, fileMessage.getContent());
                }
            });
            LoadingIndicatorView loadingView = (LoadingIndicatorView)((Object)holder.getView(this.getViewId("aihelp_iv_msg_sending")));
            loadingView.setIndicatorColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
            AppCompatImageButton retryButton = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_msg_retry"));
            switch (message.getMsgStatus()) {
                case 1: {
                    loadingView.setVisibility(8);
                    retryButton.setVisibility(8);
                    break;
                }
                case 2: {
                    loadingView.setVisibility(0);
                    retryButton.setVisibility(8);
                    break;
                }
                case 3: {
                    loadingView.setVisibility(8);
                    retryButton.setVisibility(0);
                    retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                    retryButton.setOnClickListener(this.getFileRetryListener(position, message));
                }
            }
        }
    }

    private int getRightfulMaxWidthForFileName() {
        return Styles.getScreenWidth(this.mContext) - this.dip2px(this.mContext, 60.0) - this.dip2px(this.mContext, 36.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 23.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 20.0) - this.dip2px(this.mContext, 39.0);
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15) : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }
}

