/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import androidx.fragment.app.Fragment;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class UserImageAdapter
extends BaseMsgAdapter {
    public UserImageAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_image");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == 11;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        if (message instanceof FileMessage) {
            final FileMessage fileMessage = (FileMessage)message;
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");
            holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), false);
            if (fileMessage.getMsgStatus() == 2) {
                AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
                imageView.resetStatus();
                return;
            }
            final AIHelpLoadingImageView imageView = (AIHelpLoadingImageView)((Object)holder.getView(this.getViewId("aihelp_iv_holder")));
            imageView.loadIntoImageView(this.mContext, fileMessage);
            if (fileMessage.getMsgStatus() == 3) {
                holder.setVisible(this.getViewId("aihelp_iv_msg_retry"), true);
                holder.setOnClickListener(this.getViewId("aihelp_iv_msg_retry"), this.getFileRetryListener(position, message));
                return;
            }
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (imageView.isLoading()) {
                        return;
                    }
                    PreviewActivity.startAct(UserImageAdapter.this.mFragment, PreviewInfo.get(fileMessage.getContent()));
                }
            });
        }
    }
}

