/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpFlowLayout;
import net.aihelp.ui.widget.AIHelpScrollView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class BottomActionPickerView
extends BottomBaseView
implements AIHelpFlowLayout.OnLabelClickedListener,
View.OnClickListener {
    private final AIHelpButton tvSkip;
    private final AIHelpFlowLayout actionList;

    public BottomActionPickerView(Context context) {
        this(context, null);
    }

    public BottomActionPickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomActionPickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_action_picker"), (ViewGroup)this);
        TextView tvHint = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_hint"));
        Styles.reRenderTextView(tvHint, ResResolver.getString("aihelp_select_option"));
        this.tvSkip = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_tv_skip_action_picker"));
        this.tvSkip.setOnClickListener(this);
        this.tvSkip.setMaxWidth((int)((float)Styles.getScreenWidth(this.getContext()) * 0.3f));
        AIHelpScrollView scrollView = (AIHelpScrollView)this.findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();
        this.actionList = (AIHelpFlowLayout)this.findViewById(ResResolver.getViewId("aihelp_fl_actions"));
        this.actionList.setOnLabelClickedListener(this);
    }

    @Override
    public void onLabelClicked(RPAStep.Action action) {
        if (AppInfoUtil.validateNetwork(this.getContext()) && this.mListener != null && action != null) {
            String id2 = action.getId();
            String content = action.getContent();
            UserMessage userMessage = Message.getUserTextMsg(content);
            userMessage.setRequestParams(content, false, 2, id2, 2);
            this.mListener.onUserAction(userMessage);
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_tv_skip_action_picker") && this.tvSkip != null && this.mListener != null) {
            String skip = this.tvSkip.getText().toString();
            UserMessage userMessage = Message.getUserTextMsg(skip);
            userMessage.setRequestParams(skip, true, 2, "", 7);
            this.mListener.onUserAction(userMessage);
            this.tvSkip.setVisibility(8);
        }
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);
        this.tvSkip.setVisibility(step.isEnableSkip() ? 0 : 8);
        this.tvSkip.setText(step.getSkipHint());
        this.actionList.update(step.getActionList(), false);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        AIHelpScrollView scrollView = (AIHelpScrollView)this.findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        if (scrollView != null) {
            scrollView.updateMaxHeight();
        }
    }
}

