/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import java.io.File;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.event.HideAttachmentMenuEvent;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomManualInputView;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;

public abstract class BottomBaseView
extends LinearLayout
implements View.OnClickListener,
IAttachmentPickerListener {
    protected Bundle bundle;
    protected RPAStep mStep;
    protected IServiceEventListener mListener;
    protected EditText etInput;
    protected AppCompatImageButton btnSend;

    public BottomBaseView(Context context) {
        super(context);
    }

    public BottomBaseView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomBaseView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        this.bundle = bundle;
        this.mStep = step;
        this.mListener = listener;
    }

    protected void prepareInputView() {
        this.etInput = (EditText)this.findViewById(ResResolver.getViewId("aihelp_et_input"));
        this.btnSend = (AppCompatImageButton)this.findViewById(ResResolver.getViewId("aihelp_btn_send"));
        if (this.etInput != null && this.btnSend != null) {
            this.btnSend.setOnClickListener((View.OnClickListener)this);
            this.btnSend.setEnabled(false);
            this.etInput.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), 8));
            Styles.reRenderTextView((TextView)this.etInput, CustomConfig.CustomerService.csInputHint);
            this.etInput.addTextChangedListener((TextWatcher)new TextWatcherWrapper(){

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    BottomBaseView.this.onInputTextChanged(s.toString().trim());
                    BottomBaseView.this.updateSendButtonStatus(s.toString().trim());
                }
            });
            this.etInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        EventBus.getDefault().post(new HideAttachmentMenuEvent());
                        SoftInputUtil.showSoftInput(BottomBaseView.this.getContext());
                    } else {
                        SoftInputUtil.hideSoftInput(BottomBaseView.this.getContext(), v);
                    }
                }
            });
            this.etInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == 6) {
                        BottomBaseView.this.etInput.clearFocus();
                        if (BottomBaseView.this.mListener != null) {
                            BottomBaseView.this.mListener.onEditTextEditDone();
                        }
                        return true;
                    }
                    return false;
                }
            });
            if (this instanceof BottomManualInputView) {
                this.etInput.setText((CharSequence)SpUtil.getInstance().getString("sp_input_draft", ""));
            } else {
                this.etInput.setText((CharSequence)"");
            }
        }
    }

    protected void onInputTextChanged(CharSequence s) {
    }

    private void updateSendButtonStatus(CharSequence s) {
        try {
            if (this.btnSend != null) {
                boolean isSendEnable = !TextUtils.isEmpty((CharSequence)s.toString().trim());
                this.btnSend.setEnabled(isSendEnable);
                Drawable drawable = Styles.getClickableDrawable(this.getContext(), "aihelp_svg_ic_send_msg", Color.parseColor((String)(isSendEnable ? CustomConfig.CommonSetting.interactElementTextColor : "#C6C9D7")), isSendEnable);
                this.btnSend.setImageDrawable(drawable);
                if (Build.VERSION.SDK_INT >= 17 && this.btnSend.getContext().getResources().getConfiguration().getLayoutDirection() == 1) {
                    this.btnSend.setScaleX(-1.0f);
                }
                Styles.scaleView((View)this.btnSend);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.etInput != null) {
            if (this instanceof BottomManualInputView) {
                SpUtil.getInstance().put("sp_input_draft", this.etInput.getText().toString().trim());
            } else {
                this.etInput.setText((CharSequence)"");
            }
        }
    }

    public void onClick(View v) {
    }

    @Override
    public void onPickSuccess(File pickedFile) {
    }

    @Override
    public void onPickFailure(int errCode) {
    }

    @Override
    public void onPreviewCanceled(int attachmentType) {
    }

    @Override
    public void onPreviewConfirmed(String filePath) {
    }
}

