/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.logic.cs.predict.PredictHelper;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DebounceHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class BottomBotInputView
extends BottomBaseView
implements View.OnClickListener {
    private int inputType;
    private final TextView tvHint;

    public BottomBotInputView(Context context) {
        super(context);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_input_for_bot"), (ViewGroup)this);
        this.tvHint = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_hint"));
        this.prepareInputView();
    }

    @Override
    public void onClick(View v) {
        if (this.etInput != null && AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            String input = this.etInput.getText().toString().trim();
            switch (this.inputType) {
                case 2: {
                    if (Pattern.compile("[0-9]*").matcher(input).matches()) break;
                    this.updateInputValidator(ResResolver.getString("aihelp_enter_number"), true);
                    return;
                }
                case 32: {
                    if (Pattern.compile("^([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-.])+\\.([A-Za-z]{2,4})$").matcher(input).matches()) break;
                    this.updateInputValidator(ResResolver.getString("aihelp_enter_email_address"), true);
                    return;
                }
            }
            if (this.mListener != null) {
                this.etInput.setText((CharSequence)"");
                SoftInputUtil.hideSoftInput(this.getContext(), (View)this.etInput);
                UserMessage userMessage = Message.getUserTextMsg(input);
                userMessage.setRequestParams(input, 1, 1);
                this.mListener.onUserAction(userMessage);
                StatisticTracker.getInstance().onUserInput();
            }
        }
    }

    private void updateInputValidator(String hint, boolean visible) {
        this.tvHint.setVisibility(visible ? 0 : 8);
        Styles.reRenderTextView(this.tvHint, hint, Color.parseColor((String)"#D22121"), visible, 11);
    }

    @Override
    protected void onInputTextChanged(final CharSequence s) {
        if (TicketStatusTracker.isTicketServingByAnswerBot()) {
            if (TextUtils.isEmpty((CharSequence)s) || s.length() > 200) {
                DebounceHelper.INSTANCE.resetTimer();
                if (this.mListener != null) {
                    this.mListener.onPredictResult(s, new ArrayList<FaqListEntity>());
                }
            } else {
                DebounceHelper.INSTANCE.debounceAsync(new Runnable(){

                    @Override
                    public void run() {
                        final List<FaqListEntity> faqs = PredictHelper.getPredictList(String.valueOf(s));
                        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (BottomBotInputView.this.mListener != null) {
                                    BottomBotInputView.this.mListener.onPredictResult(s, faqs);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);
        if (this.etInput != null) {
            switch (step.getNextStep()) {
                case 1: {
                    this.inputType = 1;
                    this.etInput.setHint((CharSequence)CustomConfig.CustomerService.csInputHint);
                    break;
                }
                case 2: {
                    this.inputType = 32;
                    this.etInput.setHint((CharSequence)ResResolver.getString("aihelp_enter_email_address"));
                    break;
                }
                case 3: {
                    this.inputType = 2;
                    this.etInput.setHint((CharSequence)ResResolver.getString("aihelp_enter_number"));
                }
            }
        }
    }
}

