/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.util.Calendar;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class BottomDatePickerView
extends BottomBaseView
implements View.OnClickListener {
    private LinearLayout llDatePicker;
    private TextView tvDate;
    private AppCompatImageButton btnSend;
    private DatePickerDialog pickerDialog;
    private int currentYear;
    private int currentMonth;
    private int currentDayOfMonth;

    public BottomDatePickerView(Context context) {
        this(context, null);
    }

    public BottomDatePickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomDatePickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_date_picker"), (ViewGroup)this);
        this.llDatePicker = (LinearLayout)this.findViewById(ResResolver.getViewId("aihelp_ll_date"));
        this.tvDate = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_date"));
        this.btnSend = (AppCompatImageButton)this.findViewById(ResResolver.getViewId("aihelp_btn_send"));
        this.llDatePicker.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), 8));
        this.llDatePicker.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderTextView(this.tvDate, ResResolver.getString("aihelp_select_date"), 0.5f);
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        this.btnSend.setEnabled(false);
        Calendar ca = Calendar.getInstance();
        this.currentYear = ca.get(1);
        this.currentMonth = ca.get(2);
        this.currentDayOfMonth = ca.get(5);
    }

    @Override
    public void onClick(View v) {
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_ll_date")) {
            this.showDatePicker(this.currentYear, this.currentMonth, this.currentDayOfMonth);
        }
        if (AppInfoUtil.validateNetwork(this.getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send") && AppInfoUtil.validateNetwork(this.getContext()) && this.mListener != null) {
            String input = this.tvDate.getText().toString().trim();
            UserMessage userMessage = Message.getUserTextMsg(input);
            userMessage.setRequestParams(input, 3, 3);
            this.mListener.onUserAction(userMessage);
        }
    }

    private void updateSendButtonStatus(CharSequence s) {
        try {
            VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)this.getResources(), (int)ResResolver.getDrawableId("aihelp_svg_ic_send_msg"), null);
            if (drawable != null) {
                int greyColor = Color.parseColor((String)"#C6C9D7");
                int blueColor = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
                if (!TextUtils.isEmpty((CharSequence)s.toString().trim())) {
                    this.btnSend.setEnabled(true);
                    DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)blueColor);
                } else {
                    this.btnSend.setEnabled(false);
                    DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)greyColor);
                }
                this.btnSend.setImageDrawable((Drawable)drawable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (this.pickerDialog != null && this.pickerDialog.isShowing()) {
            this.pickerDialog.dismiss();
            this.showDatePicker(this.currentYear, this.currentMonth, this.currentDayOfMonth);
        }
    }

    private void showDatePicker(int year, int month, int day) {
        this.pickerDialog = new DatePickerDialog(this.getContext(), new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                BottomDatePickerView.this.currentYear = year;
                BottomDatePickerView.this.currentMonth = month;
                BottomDatePickerView.this.currentDayOfMonth = dayOfMonth;
                String data = String.format("%s%s%s", BottomDatePickerView.this.currentYear, BottomDatePickerView.this.currentMonth + 1 < 10 ? "0" + (BottomDatePickerView.this.currentMonth + 1) : Integer.valueOf(BottomDatePickerView.this.currentMonth + 1), BottomDatePickerView.this.currentDayOfMonth < 10 ? "0" + BottomDatePickerView.this.currentDayOfMonth : Integer.valueOf(BottomDatePickerView.this.currentDayOfMonth));
                Styles.reRenderTextView(BottomDatePickerView.this.tvDate, data);
                BottomDatePickerView.this.updateSendButtonStatus(data);
            }
        }, year, month, day);
        this.pickerDialog.show();
    }
}

