/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.ui.widget.AIHelpScrollView;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class BottomEvaluateServiceView
extends BottomBaseView {
    private final LinearLayout llFeedbackLayout;
    private EditText etFeedback;
    private SparseArray<JSONArray> opinionArray;
    private int selectedRateValue = 5;
    private final List<String> selectedOptionIds = new ArrayList<String>();
    private String inputFeedback = "";

    public BottomEvaluateServiceView(final Context context) {
        super(context);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_evaluate_service_view"), (ViewGroup)this);
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        RelativeLayout rateLayout = (RelativeLayout)this.findViewById(ResResolver.getViewId("aihelp_rl_rate_layout"));
        rateLayout.setBackgroundColor(backgroundColor);
        TextView tvRatingDislike = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_rating_dislike"));
        Styles.reRenderTextView(tvRatingDislike, ResResolver.getString("aihelp_rate_dissatisfied"));
        TextView tvRatingLike = (TextView)this.findViewById(ResResolver.getViewId("aihelp_tv_rating_like"));
        Styles.reRenderTextView(tvRatingLike, ResResolver.getString("aihelp_rate_satisfied"));
        this.llFeedbackLayout = (LinearLayout)this.findViewById(ResResolver.getViewId("aihelp_ll_feedback"));
        AIHelpRatingBar ratingBar = (AIHelpRatingBar)this.findViewById(ResResolver.getViewId("aihelp_rating_bar"));
        if (ratingBar != null) {
            ratingBar.setOnStatusChangedListener(new AIHelpRatingBar.OnStatusChangedListener(){

                @Override
                public void onRateStatusChanged(int newRateValue) {
                    BottomEvaluateServiceView.this.selectedOptionIds.clear();
                    BottomEvaluateServiceView.this.selectedRateValue = newRateValue;
                    if (BottomEvaluateServiceView.this.opinionArray != null) {
                        BottomEvaluateServiceView.this.resetFeedbackOptions(BottomEvaluateServiceView.this.getContext(), (JSONArray)BottomEvaluateServiceView.this.opinionArray.get(newRateValue));
                    }
                }
            });
        }
        AIHelpButton btnConfirm = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_btn_confirm"));
        btnConfirm.setText(ResResolver.getString("aihelp_yes")).setFullWidth();
        btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BottomEvaluateServiceView.this.mStep != null && BottomEvaluateServiceView.this.mStep.isOptionRequired() && BottomEvaluateServiceView.this.noOptionsSelected()) {
                    ToastUtil.INSTANCE.makeRawToast(BottomEvaluateServiceView.this.getContext(), ResResolver.getString("aihelp_select_option"));
                    return;
                }
                if (AppInfoUtil.validateNetwork(context)) {
                    UserMessage userMessage = new UserMessage();
                    userMessage.setRequestType(3);
                    userMessage.setRequestParams(BottomEvaluateServiceView.this.getRequestParams());
                    userMessage.setEvaluateGrade(BottomEvaluateServiceView.this.selectedRateValue);
                    userMessage.setContent(String.format("%s\n%s", BottomEvaluateServiceView.this.getSelectedOptions(), BottomEvaluateServiceView.this.getInputFeedback()).trim());
                    userMessage.setMsgType(15);
                    BottomEvaluateServiceView.this.mListener.onUserAction(userMessage);
                }
                SpUtil.getInstance().put(UserProfile.USER_ID, 0);
                TicketStatusTracker.resetTicketStatusFlags();
            }
        });
        AIHelpScrollView scrollView = (AIHelpScrollView)this.findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();
        SoftInputUtil.hideSoftInput(this.getContext(), (View)this);
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        super.setBottomViewEventListener(bundle, step, listener);
        if (step != null) {
            this.opinionArray = step.getOpinionArray();
            if (this.opinionArray != null) {
                this.resetFeedbackOptions(this.getContext(), (JSONArray)this.opinionArray.get(this.selectedRateValue));
            }
        }
    }

    private boolean noOptionsSelected() {
        JSONArray selectedOptions = new JSONArray();
        if (this.opinionArray != null) {
            JSONArray options = (JSONArray)this.opinionArray.get(this.selectedRateValue);
            for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
                String id2 = this.selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); ++j) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (!id2.equals(JsonHelper.optString(object, "id"))) continue;
                    selectedOptions.put((Object)object);
                }
            }
            return options.length() > 0 && selectedOptions.length() == 0;
        }
        return false;
    }

    private String getInputFeedback() {
        String input = "";
        if (this.etFeedback != null) {
            input = this.etFeedback.getText().toString();
        }
        return input;
    }

    private String getSelectedOptions() {
        StringBuilder selectedOptions = new StringBuilder();
        if (this.opinionArray != null) {
            JSONArray options = (JSONArray)this.opinionArray.get(this.selectedRateValue);
            for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
                String id2 = this.selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); ++j) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (!id2.equals(JsonHelper.optString(object, "id"))) continue;
                    selectedOptions.append(JsonHelper.optString(object, "value"));
                    if (i == this.selectedOptionIds.size() - 1) continue;
                    selectedOptions.append(",");
                }
            }
        }
        return selectedOptions.toString();
    }

    private JSONObject getRequestParams() {
        JSONArray selectedOptions = new JSONArray();
        if (this.opinionArray != null) {
            JSONArray options = (JSONArray)this.opinionArray.get(this.selectedRateValue);
            for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
                String id2 = this.selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); ++j) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (!id2.equals(JsonHelper.optString(object, "id"))) continue;
                    String value = JsonHelper.optString(object, "value");
                    JSONObject optionObject = JsonHelper.getJsonObject();
                    JsonHelper.put(optionObject, "id", Integer.parseInt(id2));
                    JsonHelper.put(optionObject, "msg", value);
                    selectedOptions.put((Object)optionObject);
                }
            }
        }
        JSONObject evaluateParams = new JSONObject();
        JsonHelper.put(evaluateParams, "starIndex", this.selectedRateValue);
        JsonHelper.put(evaluateParams, "elseMsg", this.getInputFeedback());
        JsonHelper.put(evaluateParams, "chooseList", selectedOptions);
        JsonHelper.put(evaluateParams, "userId", UserProfile.USER_ID);
        return evaluateParams;
    }

    private void resetFeedbackOptions(Context context, JSONArray options) {
        AIHelpScrollView scrollView = (AIHelpScrollView)this.findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();
        if (Styles.isLandscape()) {
            this.prepareFeedbackForLandscape(context, options);
        } else {
            this.prepareFeedbackForPortrait(context, options);
        }
    }

    private void prepareFeedbackForPortrait(Context context, JSONArray options) {
        this.llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); ++i) {
                this.llFeedbackLayout.addView(this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i)));
            }
            this.prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackForLandscape(Context context, JSONArray options) {
        this.llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i += 2) {
                View previousView = this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i));
                View afterwardsView = null;
                if (i + 1 < options.length()) {
                    afterwardsView = this.getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i + 1));
                }
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(0);
                linearLayout.addView(previousView);
                if (afterwardsView != null) {
                    linearLayout.addView(afterwardsView);
                }
                this.llFeedbackLayout.addView((View)linearLayout);
            }
            this.prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackInput(Context context) {
        View view = View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_feedback_input"), null);
        view.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), 8));
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(-1, -2);
        marginLayoutParams.topMargin = Styles.dpToPx(context, 10.0f);
        view.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
        this.etFeedback = (EditText)view.findViewById(ResResolver.getViewId("aihelp_et_feedback_input"));
        Styles.reRenderTextView((TextView)this.etFeedback, ResResolver.getString("aihelp_rate_additional_feedback_message"));
        this.etFeedback.setGravity(Styles.isLayoutRtl((View)this) ? 0x800005 : 0x800003);
        final TextView tvMaxLength = (TextView)view.findViewById(ResResolver.getViewId("aihelp_tv_max_length"));
        Styles.reRenderTextView(tvMaxLength, "0/500", Styles.getColor(CustomConfig.CommonSetting.textColor));
        this.etFeedback.addTextChangedListener((TextWatcher)new TextWatcherWrapper(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvMaxLength.setText((CharSequence)String.format("%s/%s", s.length(), 500));
            }
        });
        this.etFeedback.setMaxHeight(Styles.dpToPx(context, 120.0f));
        if (!TextUtils.isEmpty((CharSequence)this.inputFeedback)) {
            this.etFeedback.setText((CharSequence)this.inputFeedback);
        }
        this.llFeedbackLayout.addView(view);
    }

    private View getFeedbackOptionItem(final Context context, final JSONObject opinion) {
        CheckBox checkBox = (CheckBox)View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_layout_feedback_option"), null);
        String id2 = JsonHelper.optString(opinion, "id");
        String value = JsonHelper.optString(opinion, "value");
        Styles.reRenderTextView((TextView)checkBox, value);
        for (int i = 0; i < this.selectedOptionIds.size(); ++i) {
            if (!id2.equals(this.selectedOptionIds.get(i))) continue;
            checkBox.setChecked(true);
            break;
        }
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    BottomEvaluateServiceView.this.selectedOptionIds.add(JsonHelper.optString(opinion, "id"));
                } else {
                    BottomEvaluateServiceView.this.selectedOptionIds.remove(JsonHelper.optString(opinion, "id"));
                }
                BottomEvaluateServiceView.this.updateCheckBoxEnableStatus(context);
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{-16842912}, {0x10100A0}}, new int[]{Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, (double)0.1f), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor)});
            checkBox.setButtonTintList(colorStateList);
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.weight = 1.0f;
        checkBox.setLayoutParams((ViewGroup.LayoutParams)params);
        return checkBox;
    }

    private void updateCheckBoxEnableStatus(Context context) {
        int childCount = this.llFeedbackLayout.getChildCount();
        if (Styles.isLandscape()) {
            for (int i = 0; i < childCount; ++i) {
                View childView = this.llFeedbackLayout.getChildAt(i);
                if (!(childView instanceof LinearLayout)) continue;
                LinearLayout layout = (LinearLayout)childView;
                for (int j = 0; j < layout.getChildCount(); ++j) {
                    CheckBox checkBox;
                    View view = layout.getChildAt(j);
                    if (!(view instanceof CheckBox) || (checkBox = (CheckBox)view).isChecked() || this.mStep == null) continue;
                    checkBox.setEnabled(this.selectedOptionIds.size() < this.mStep.getMaxOptionCount());
                }
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                CheckBox checkBox;
                View childView = this.llFeedbackLayout.getChildAt(i);
                if (!(childView instanceof CheckBox) || (checkBox = (CheckBox)childView).isChecked() || this.mStep == null) continue;
                checkBox.setEnabled(this.selectedOptionIds.size() < this.mStep.getMaxOptionCount());
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter<?> event) {
        if (event instanceof OrientationChangeEvent && this.etFeedback != null) {
            this.inputFeedback = this.etFeedback.getText().toString();
            if (this.opinionArray != null) {
                this.resetFeedbackOptions(this.etFeedback.getContext(), (JSONArray)this.opinionArray.get(this.selectedRateValue));
            }
        }
    }
}

