/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.cs.bottom.BottomBaseView;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import org.json.JSONObject;

public class BottomResolveConfirmView
extends BottomBaseView {
    private final AIHelpButton resolutionNo;
    private final AIHelpButton resolutionYes;

    public BottomResolveConfirmView(final Context context) {
        super(context);
        View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_bottom_resolve_confirm_view"), (ViewGroup)this);
        this.resolutionNo = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_resolution_no"));
        this.resolutionNo.setText(ResResolver.getString("aihelp_resolution_no"));
        this.resolutionNo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(BottomResolveConfirmView.this.getContext()) && BottomResolveConfirmView.this.mListener != null) {
                    String text = BottomResolveConfirmView.this.resolutionNo.getText();
                    UserMessage userMessage = Message.getUserTextMsg(text);
                    userMessage.setRequestType(2);
                    userMessage.setRequestParams(BottomResolveConfirmView.this.getRequestParams(context, false, text));
                    BottomResolveConfirmView.this.mListener.onUserAction(userMessage);
                }
            }
        });
        this.resolutionYes = (AIHelpButton)this.findViewById(ResResolver.getViewId("aihelp_resolution_yes"));
        this.resolutionYes.setText(ResResolver.getString("aihelp_resolution_yes"));
        this.resolutionYes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(BottomResolveConfirmView.this.getContext()) && BottomResolveConfirmView.this.mListener != null) {
                    String text = BottomResolveConfirmView.this.resolutionYes.getText();
                    UserMessage userMessage = Message.getUserTextMsg(text);
                    userMessage.setRequestType(2);
                    userMessage.setRequestParams(BottomResolveConfirmView.this.getRequestParams(context, true, text));
                    BottomResolveConfirmView.this.mListener.onUserAction(userMessage);
                }
            }
        });
    }

    private JSONObject getRequestParams(Context context, boolean isResolved, String resolveMsg) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "userId", UserProfile.USER_ID);
        JsonHelper.put(params, "deviceId", DeviceUuidFactory.id(context));
        JsonHelper.put(params, "resolveType", isResolved ? 1 : 2);
        JsonHelper.put(params, "resolveMsg", resolveMsg);
        return params;
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);
        if (step.getActionList() != null && step.getActionList().size() >= 2) {
            List<RPAStep.Action> actionList = step.getActionList();
            if (this.resolutionYes != null && this.resolutionNo != null) {
                RPAStep.Action secondAction;
                RPAStep.Action firstAction = actionList.get(0);
                if (firstAction != null) {
                    this.resolutionYes.setText(firstAction.getContent());
                }
                if ((secondAction = actionList.get(1)) != null) {
                    this.resolutionNo.setText(secondAction.getContent());
                }
            }
        }
    }
}

