/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.API;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.logic.cs.rpa.helper.ResponseHelper;
import net.aihelp.data.logic.faq.FaqPresenter;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.helper.WebViewInjector;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class FaqContentFragment
extends BaseFaqFragment<FaqPresenter> {
    private boolean showEntranceAfterEvaluated;
    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;
    private AIHelpButton mAttachedForm;
    private AIHelpEvaluateView mEvaluateView;
    private AIHelpServiceEntrance mServiceEntrance;
    private String currentSectionId;

    public static FaqContentFragment newInstance(Bundle bundle) {
        FaqContentFragment faqFragment = new FaqContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
        this.currentSectionId = extras.getString("section_id", "");
    }

    @Override
    protected void initEventAndData(View view) {
        FrameLayout flContent = (FrameLayout)this.get("aihelp_ll_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);
        this.mProgressBar = (AIHelpWebProgress)((Object)this.get("aihelp_progress_bar"));
        this.mAttachedForm = (AIHelpButton)((Object)this.get("aihelp_btn_form"));
        this.mEvaluateView = (AIHelpEvaluateView)((Object)this.get("aihelp_evaluate_faq"));
        this.mServiceEntrance = (AIHelpServiceEntrance)((Object)this.get("aihelp_cs_entrance"));
        this.mWebView = (AIHelpWebView)((Object)this.get("aihelp_web_view"));
        this.mWebView.setBackgroundColor(0);
        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(this.getContext(), this.mProgressBar, true);
        this.mWebView.setWebViewClient(webViewClient);
        WebViewInjector.getInstance().setHostFragment(this).inject(this.mWebView, webViewClient);
        this.mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, this.mProgressBar));
        if (this.intentMode == 4) {
            ((FaqPresenter)this.mPresenter).prepareFAQNotification();
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String sectionId = extras.getString("section_id");
        String faqId = extras.getString("faq_main_id");
        String searchTerm = extras.getString("search_match");
        ((FaqPresenter)this.mPresenter).goFetchQuestionContent(sectionId, faqId, searchTerm);
        if (TextUtils.isEmpty((CharSequence)sectionId) && TextUtils.isEmpty((CharSequence)searchTerm)) {
            this.titleText = AppInfoUtil.getAppName(this.getContext());
        }
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_faq_content");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_faq_content");
    }

    @Override
    public void refreshQuestionContent(final FaqContentEntity faq, String searchTerm) {
        super.refreshQuestionContent(faq, searchTerm);
        if (faq != null) {
            if (!(TicketStatusTracker.isTicketActive || TextUtils.isEmpty((CharSequence)faq.getFormTitle()) || TextUtils.isEmpty((CharSequence)faq.getFormUrl()))) {
                this.mAttachedForm.setVisibility(0);
                this.mAttachedForm.setText(faq.getFormTitle());
                this.mAttachedForm.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Bundle bundle = new Bundle();
                        bundle.putString("intent_url", String.format("%s&userId=%s", faq.getFormUrl(), UserProfile.USER_ID));
                        EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
                        JSONObject loginParams = ResponseHelper.getLoginParams();
                        AIHelpRequest.getInstance().requestPostByJson(API.LOGIN, loginParams, null);
                    }
                });
            } else {
                this.mAttachedForm.setVisibility(8);
            }
            this.mEvaluateView.setFaqData(faq.getFaqTitle(), faq.getFaqMainId(), faq.getFaqContentId());
            if (CustomConfig.InitSetting.isEvaluationForAnswerPageEnable && ((FaqPresenter)this.mPresenter).shouldShowQuestionFooter(faq.getFaqMainId(), faq.getLastUpdateTime())) {
                this.mEvaluateView.setEvaluateState(1);
            } else {
                this.mEvaluateView.setEvaluateState(2);
            }
            this.mEvaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback(){

                @Override
                public void onEvaluated(boolean isHelpful) {
                    String supportMoment;
                    if (!isHelpful && FaqContentFragment.this.getArguments() != null && (supportMoment = FaqContentFragment.this.getArguments().getString("faq_support_moment", "")).contains("4")) {
                        FaqContentFragment.this.mServiceEntrance.setVisibility(0);
                        FaqContentFragment.this.showEntranceAfterEvaluated = true;
                    }
                    FaqHelper.INSTANCE.afterFaqEvaluated(faq.getFaqMainId(), faq.getLastUpdateTime());
                }
            });
            String faqContent = DomainSupportHelper.getAdjustedUrl(faq.getFaqContent());
            int[] colorRGB = Styles.getColorRGB(CustomConfig.CommonSetting.textColor);
            String textColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 1);
            String timeColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 0.3);
            faqContent = faqContent.replace("<body>", String.format("<body style=\"background-color: transparent; %s\">", textColor));
            faqContent = faqContent.replace("<div style='font-size:14px;color:#CCCCCC;'>", String.format("<div style='font-size:14px; %s'>", timeColor));
            faqContent = faqContent.replaceAll("(?i)(\\.(mp4|mov))", "$1#t=0.01");
            faqContent = this.scaleFaqContent(faqContent, "font-size");
            this.mWebView.loadDataWithBaseURL(null, faqContent, "text/html", "utf-8", null);
            this.handleTrackLogic(faq, searchTerm);
        } else {
            this.showEmpty(new int[0]);
        }
    }

    private String scaleFaqContent(String content, String key) {
        StringBuffer output = new StringBuffer();
        try {
            Pattern pattern = Pattern.compile(String.format("(%s:)\\s*(\\d+(?:\\.\\d+)?)([^;]+)?", key));
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String firstGroup = matcher.group(1);
                String secondGroup = matcher.group(2);
                String thirdGroup = matcher.group(3);
                if (TextUtils.isEmpty((CharSequence)firstGroup) || TextUtils.isEmpty((CharSequence)secondGroup)) continue;
                float oldSize = Float.parseFloat(secondGroup);
                String replacement = String.format("%s%s%s", firstGroup, Float.valueOf(oldSize * CustomConfig.CommonSetting.scaleFactor), TextUtils.isEmpty((CharSequence)thirdGroup) ? "" : thirdGroup);
                matcher.appendReplacement(output, replacement);
            }
            matcher.appendTail(output);
            return output.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    private void handleTrackLogic(FaqContentEntity faq, String searchTerm) {
        switch (this.currentSectionId) {
            case "faqNotification": {
                StatisticTracker.getInstance().clickNotification(faq.getFaqMainId(), faq.getFaqContentId(), faq.getFaqTitle());
                break;
            }
            case "faqHotTopics": {
                StatisticTracker.getInstance().clickHotTopic(faq.getFaqMainId(), faq.getFaqContentId(), faq.getFaqTitle());
                break;
            }
            default: {
                ProcessEntity currentProcess = ProcessEntranceHelper.INSTANCE.getCurrentProcess();
                if (currentProcess == null || currentProcess.getIntent() != 2 || !currentProcess.getSectionId().equals(this.currentSectionId)) break;
                StatisticTracker.getInstance().clickFaq(faq.getFaqMainId(), faq.getFaqContentId(), faq.getFaqTitle());
            }
        }
        StatisticTracker.getInstance().checkedFAQ(faq.getFaqMainId(), faq.getFaqContentId(), faq.getFaqTitle());
        EventTracker.INSTANCE.log(204, "sectionId", this.currentSectionId, "faqMainId", faq.getFaqMainId(), "faqTitle", faq.getFaqTitle(), "query", searchTerm);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.showEntranceAfterEvaluated) {
            this.mServiceEntrance.setVisibility(0);
        }
        if (this.mAttachedForm != null && this.mAttachedForm.getVisibility() == 0 && TicketStatusTracker.isTicketActive) {
            this.mAttachedForm.setVisibility(8);
            if (this.csEntrance != null) {
                this.csEntrance.onIntentToCustomerService(this.getMergedBundle(), this.getFaqFlowListener(), this);
            }
        }
    }

    public void onStop() {
        super.onStop();
        this.mProgressBar.hide();
    }

    public void onDestroy() {
        super.onDestroy();
        EventTracker.INSTANCE.log(205, new Object[0]);
    }

    public boolean onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return false;
        }
        return true;
    }
}

