/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NetErrorEvent;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.faq.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.widget.AIHelpFaqCardLayout;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqHomeFragment
extends BaseFaqFragment<FaqPresenter> {
    private LinearLayout llRootLayout;
    LinearLayout llNotification;
    AIHelpFaqCardLayout rvHotTopics;
    AIHelpFaqCardLayout rvCommonQuestions;
    private boolean isNotificationEmpty = true;
    private boolean isHotTopicsEmpty = true;
    private boolean isSectionsEmpty = true;

    public static FaqHomeFragment newInstance(Bundle bundle) {
        FaqHomeFragment faqFragment = new FaqHomeFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
    }

    @Override
    protected void initEventAndData(View view) {
        EventTracker.INSTANCE.log(200, new Object[0]);
        this.llNotification = (LinearLayout)this.get("aihelp_ll_notification");
        this.llRootLayout = (LinearLayout)this.get("aihelp_ll_root");
        this.prepareScreenOrientationAndDataSource();
    }

    private void prepareScreenOrientationAndDataSource() {
        if (this.llRootLayout != null) {
            this.llRootLayout.removeAllViews();
            if (Styles.isLandscape()) {
                View.inflate((Context)this.getContext(), (int)ResResolver.getLayoutId("aihelp_layout_faq_home_land"), (ViewGroup)this.llRootLayout);
            } else {
                View.inflate((Context)this.getContext(), (int)ResResolver.getLayoutId("aihelp_layout_faq_home_port"), (ViewGroup)this.llRootLayout);
            }
            this.rvHotTopics = (AIHelpFaqCardLayout)this.llRootLayout.findViewById(ResResolver.getViewId("aihelp_rv_hot_topics"));
            this.rvCommonQuestions = (AIHelpFaqCardLayout)this.llRootLayout.findViewById(ResResolver.getViewId("aihelp_rv_common_questions"));
        }
        if (this.getArguments() != null && this.isViewRestored()) {
            ((FaqPresenter)this.mPresenter).goFetchFAQDataSource(this.getArguments().getString("section_id"));
        }
    }

    private void prepareFlipperView(List<FaqListEntity> notificationList) {
        if (CustomConfig.HelpCenter.isFaqNotificationVisible && !ListUtil.isListEmpty(notificationList) && this.llNotification != null) {
            this.llNotification.setVisibility(0);
            if (CustomConfig.HelpCenter.isFaqNotificationIconVisible) {
                ImageView ivNotification = (ImageView)this.get("aihelp_iv_notification");
                ivNotification.setVisibility(0);
                Styles.loadIcon(ivNotification, CustomConfig.HelpCenter.faqNotificationIcon);
            }
            ViewFlipper vfNotification = (ViewFlipper)this.get("aihelp_vf_notification");
            for (int i = 0; i < notificationList.size(); ++i) {
                vfNotification.addView(this.getNotificationView(notificationList.get(i)));
            }
            vfNotification.startFlipping();
            vfNotification.setFlipInterval(CustomConfig.HelpCenter.faqNotificationInterval * 1000);
            vfNotification.setInAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)ResResolver.getAnimId("aihelp_push_up_in")));
            vfNotification.setOutAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)ResResolver.getAnimId("aihelp_push_up_out")));
            this.isNotificationEmpty = false;
        }
    }

    private void prepareHotTopics(List<FaqListEntity> hotTopics) {
        if (CustomConfig.HelpCenter.isFaqHotTopicVisible && !ListUtil.isListEmpty(hotTopics) && this.rvHotTopics != null) {
            this.rvHotTopics.setVisibility(0);
            FaqCardLayoutAdapter hotTopicAdapter = new FaqCardLayoutAdapter(this.getContext());
            hotTopicAdapter.setup(this.getMergedBundle(), this.getFaqFlowListener(), this);
            hotTopicAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper(){
                final Bundle bundle;
                {
                    this.bundle = FaqHomeFragment.this.getMergedBundle();
                }

                @Override
                public void onIntentToQuestionContent(FaqListEntity faq) {
                    this.bundle.putString("section_id", "faqHotTopics");
                    this.bundle.putString("faq_main_id", faq.getId());
                    FaqHomeFragment.this.getFaqFlowListener().onIntentToQuestionContent(this.bundle, true);
                }
            });
            this.rvHotTopics.updateTitleIcon(CustomConfig.HelpCenter.isFaqHotTopicTitleVisible && CustomConfig.HelpCenter.isFaqHotTopicTitleIconVisible, CustomConfig.HelpCenter.faqHotTopicTitleIcon);
            this.rvHotTopics.updateTitleText(CustomConfig.HelpCenter.isFaqHotTopicTitleVisible, CustomConfig.HelpCenter.faqHotTopicsTitle);
            this.rvHotTopics.setup(hotTopicAdapter);
            hotTopicAdapter.update(hotTopics);
            this.isHotTopicsEmpty = false;
        }
    }

    private void prepareSectionList(List<FaqListEntity> sectionList) {
        if (!ListUtil.isListEmpty(sectionList) && this.rvCommonQuestions != null) {
            this.rvCommonQuestions.setVisibility(0);
            FaqCardLayoutAdapter commonQuestionAdapter = new FaqCardLayoutAdapter(this.getContext(), Styles.isLandscape());
            commonQuestionAdapter.setup(this.getMergedBundle(), this.getFaqFlowListener(), this);
            commonQuestionAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper(){
                final Bundle bundle;
                {
                    this.bundle = FaqHomeFragment.this.getMergedBundle();
                }

                @Override
                public void onIntentToSubSectionOrQuestionList(FaqListEntity faq) {
                    this.bundle.putString("section_id", faq.getId());
                    this.bundle.putString("section_name", faq.getTitle());
                    this.bundle.putString("section_icon", faq.getIconUrl());
                    FaqHomeFragment.this.getFaqFlowListener().onIntentToQuestionList(this.bundle, true);
                    StatisticTracker.getInstance().clickSection(faq.getId(), faq.getSectionName());
                }
            });
            this.rvCommonQuestions.updateTitleIcon(CustomConfig.HelpCenter.isFaqSectionTitleVisible && CustomConfig.HelpCenter.isFaqSectionTitleIconVisible, CustomConfig.HelpCenter.faqSectionTitleIcon);
            this.rvCommonQuestions.updateTitleText(CustomConfig.HelpCenter.isFaqSectionTitleVisible, CustomConfig.HelpCenter.faqSectionTitle);
            this.rvCommonQuestions.setup(CustomConfig.HelpCenter.isFaqSectionDisplayAsList, commonQuestionAdapter);
            commonQuestionAdapter.update(sectionList);
            this.isSectionsEmpty = false;
        }
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_home_list");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_main_content");
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void refreshList(List<FaqListEntity> displayFaqList, String section) {
        this.prepareFlipperView(FaqHelper.INSTANCE.getQuestionList("faqNotification"));
        this.prepareHotTopics(FaqHelper.INSTANCE.getQuestionList("faqHotTopics"));
        this.prepareSectionList(displayFaqList);
        if (this.isNotificationEmpty && this.isHotTopicsEmpty && this.isSectionsEmpty) {
            this.showEmpty(new int[0]);
        } else {
            this.csEntrance = (AIHelpServiceEntrance)((Object)this.get("aihelp_cs_entrance"));
            if (this.csEntrance != null) {
                this.csEntrance.setup(this.getMergedBundle(), this.getFaqFlowListener(), this);
            }
        }
        ((FaqPresenter)this.mPresenter).prepareFAQNotification();
    }

    private View getNotificationView(final FaqListEntity faq) {
        TextView textView = new TextView(this.getContext());
        Styles.reRenderTextView(textView, faq.getTitle(), Color.parseColor((String)CustomConfig.CommonSetting.highlightedColor), true, 14);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle bundle = FaqHomeFragment.this.getMergedBundle();
                bundle.putString("section_id", "faqNotification");
                bundle.putString("faq_main_id", faq.getId());
                FaqHomeFragment.this.getFaqFlowListener().onIntentToQuestionContent(bundle, true);
            }
        });
        return textView;
    }

    @Override
    public void showNetError() {
        super.showNetError();
        EventBus.getDefault().post(new NetErrorEvent());
    }

    @Override
    public void onEventComing(EventCenter event) {
        if (event instanceof OrientationChangeEvent) {
            this.prepareScreenOrientationAndDataSource();
            this.csEntrance = (AIHelpServiceEntrance)((Object)this.get("aihelp_cs_entrance"));
            if (this.csEntrance != null) {
                this.csEntrance.setup(this.getMergedBundle(), this.getFaqFlowListener(), this);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        EventTracker.INSTANCE.log(201, new Object[0]);
    }
}

