/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.logic.faq.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.DebounceHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class FaqSearchFragment
extends BaseFaqFragment<FaqPresenter> {
    private RecyclerView rvSearchList;
    private FaqCardLayoutAdapter mSearchAdapter;

    public static FaqSearchFragment newInstance(Bundle bundle) {
        FaqSearchFragment faqFragment = new FaqSearchFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
        EventTracker.INSTANCE.log(206, new Object[0]);
    }

    @Override
    protected void initEventAndData(View mView) {
        this.prepareRecyclerView();
    }

    private void prepareRecyclerView() {
        RelativeLayout rlSearch = (RelativeLayout)this.get("aihelp_rl_search");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlSearch.setBackgroundColor(colorFromHex);
        this.rvSearchList = (RecyclerView)this.get("aihelp_rv_faq_search");
        this.rvSearchList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSearchAdapter = new FaqCardLayoutAdapter(this.getContext(), false);
        this.mSearchAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper(){

            @Override
            public void onIntentToQuestionContent(FaqListEntity faq) {
                SoftInputUtil.hideSoftInput(FaqSearchFragment.this.getContext(), (View)FaqSearchFragment.this.rvSearchList);
                Bundle bundle = FaqSearchFragment.this.getArguments() != null ? FaqSearchFragment.this.getArguments() : new Bundle();
                bundle.putString("faq_main_id", faq.getId());
                bundle.putString("search_match", faq.getQuery());
                FaqSearchFragment.this.getFaqFlowListener().onIntentToQuestionContent(bundle, true);
            }
        });
        this.rvSearchList.setAdapter((RecyclerView.Adapter)this.mSearchAdapter);
    }

    public void onQuery(final String query) {
        ((FaqPresenter)this.mPresenter).goQueryFAQList(query);
        DebounceHelper.INSTANCE.debounce(new Runnable(){

            @Override
            public void run() {
                StatisticTracker.getInstance().trackSearchQuery(query);
                EventTracker.INSTANCE.log(207, "query", query);
            }
        }, 2000);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_search_faq");
    }

    @Override
    public void refreshSearchList(String query, List<FaqListEntity> matchedFaqList) {
        if (!this.isVisible()) {
            return;
        }
        if (matchedFaqList != null && matchedFaqList.size() == 0) {
            this.showSearchEmpty();
            this.trackFaqSearchResult(true, query);
        } else {
            this.restoreViewState();
            this.trackFaqSearchResult(false, query);
        }
        this.mSearchAdapter.update(matchedFaqList);
    }

    private void trackFaqSearchResult(final boolean isEmpty, final String query) {
        DebounceHelper.INSTANCE.debounce(new Runnable(){

            @Override
            public void run() {
                if (isEmpty) {
                    StatisticTracker.getInstance().trackSearchEmpty(query);
                    EventTracker.INSTANCE.log(208, "query", query);
                } else {
                    StatisticTracker.getInstance().trackSearchResult(query);
                }
            }
        }, 2000);
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_rv_faq_search");
    }

    public void onDestroy() {
        super.onDestroy();
        DebounceHelper.INSTANCE.resetTimer();
        EventTracker.INSTANCE.log(209, new Object[0]);
    }
}

