/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview.data;

import android.text.TextUtils;
import java.io.Serializable;
import java.util.regex.Pattern;
import net.aihelp.utils.DomainSupportHelper;

public class PreviewInfo
implements Serializable {
    public static final int PREVIEW_TYPE_IMAGE = 1;
    public static final int PREVIEW_TYPE_VIDEO = 2;
    public static final int PREVIEW_TYPE_FILE = 3;
    private int type;
    private String filePath;
    private String fileName;
    private long fileSize;
    private boolean isPicking;

    private PreviewInfo() {
    }

    public static PreviewInfo get(String filePath) {
        return PreviewInfo.get(filePath, "", 0L, false);
    }

    public static PreviewInfo get(String filePath, String fileName) {
        return PreviewInfo.get(filePath, fileName, 0L, false);
    }

    public static PreviewInfo get(String filePath, String fileName, long fileSize, boolean isPicking) {
        PreviewInfo info = new PreviewInfo();
        info.filePath = DomainSupportHelper.getAdjustedUrl(filePath);
        info.fileName = fileName;
        info.fileSize = fileSize;
        info.isPicking = isPicking;
        return PreviewInfo.preparePreviewType(info);
    }

    private static PreviewInfo preparePreviewType(PreviewInfo info) {
        String filePath = info.getFilePath();
        info.type = Pattern.compile("(?i).+\\.(png|jpg|jpeg|gif)$").matcher(filePath).matches() ? 1 : (Pattern.compile("(?i).+\\.(mp4|3gp|mkv|webm)$").matcher(filePath).matches() ? 2 : 3);
        return info;
    }

    public int getType() {
        return this.type;
    }

    public String getFilePath() {
        return TextUtils.isEmpty((CharSequence)this.filePath) ? "" : this.filePath;
    }

    public String getFileName() {
        return TextUtils.isEmpty((CharSequence)this.fileName) ? "" : this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isPicking() {
        return this.isPicking;
    }

    public boolean isImageFile() {
        return this.type == 1;
    }

    public boolean isVideoFile() {
        return this.type == 2;
    }

    public boolean isMediaFile() {
        return this.isImageFile() || this.isVideoFile();
    }
}

