/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.preview.viewer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import net.aihelp.common.CustomConfig;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

public abstract class BasePreviewer {
    private static final int BYTES_FOR_1MB = 0x100000;

    protected static boolean isFileSizeExceeded(Activity activity, PreviewInfo info) {
        if (activity == null || info == null) {
            return false;
        }
        if (info.getFileSize() > BasePreviewer.getMaxFileSize(info)) {
            BasePreviewer.fileSizeExceeded((Context)activity, info);
            BasePreviewer.closePreviewScreen(activity);
            return true;
        }
        return false;
    }

    private static void fileSizeExceeded(Context context, PreviewInfo info) {
        long maxFileSize = BasePreviewer.getMaxFileSize(info);
        String msg = ResResolver.getString("aihelp_media_upload_err_size");
        try {
            ToastUtil.INSTANCE.makeRawToast(context, String.format(msg, maxFileSize / 0x100000L));
        }
        catch (Exception e) {
            ToastUtil.INSTANCE.makeRawToast(context, msg + ", < " + maxFileSize / 0x100000L + "M");
        }
    }

    private static void closePreviewScreen(Activity activity) {
        Intent intent = activity.getIntent();
        intent.removeExtra("preview_info");
        activity.setResult(-1, intent);
        activity.finish();
    }

    private static long getMaxFileSize(PreviewInfo info) {
        int maxFileSize = 0x100000;
        if (info != null) {
            switch (info.getType()) {
                case 1: {
                    maxFileSize = CustomConfig.UploadLimit.imageMaxSize;
                    break;
                }
                case 2: {
                    maxFileSize = CustomConfig.UploadLimit.videoMaxSize;
                    break;
                }
                case 3: {
                    maxFileSize = CustomConfig.UploadLimit.fileMaxSize;
                    break;
                }
            }
        }
        return maxFileSize;
    }
}

