/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.text.TextUtils;
import android.view.Window;
import android.webkit.WebView;
import androidx.fragment.app.Fragment;
import org.json.JSONObject;

public class AIHelpJSBridge {
    private static final String CONFIG_ORIENTATION_AUTO = "1";
    private static final String CONFIG_ORIENTATION_PORTRAIT = "2";
    private static final String CONFIG_ORIENTATION_LANDSCAPE = "3";
    private static final String INTENT_TO_FINISH_PAGE = "closeWebView";
    private static final String INTENT_TO_OPEN_NEW_LINK = "OpenUrlInINTLBrowser";
    private static final String INTENT_TO_SET_FULLSCREEN = "setFullScreen";
    private static final String INTENT_TO_UPDATE_ORIENTATION = "setScreenOrientation";
    private static final String INTENT_TO_CALL_NATIVE_METHOD = "jsCallNative";
    private Fragment fragment;

    public void handleJSMessages(Fragment fragment, WebView webView, String message) {
        this.fragment = fragment;
        try {
            JSONObject jsonObject = new JSONObject(message);
            switch (jsonObject.optString("INTLMethod")) {
                case "closeWebView": {
                    this.finishPage();
                    break;
                }
                case "OpenUrlInINTLBrowser": {
                    this.openNewLink(webView, jsonObject.optString("ParamKey"));
                    break;
                }
                case "setFullScreen": {
                    this.updateFullScreen(jsonObject.optBoolean("isFullScreen"));
                    break;
                }
                case "setScreenOrientation": {
                    this.updateScreenOrientation(jsonObject.optString("screenOrientation"));
                    break;
                }
                case "jsCallNative": {
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void finishPage() {
        if (this.fragment != null && this.fragment.getActivity() != null) {
            this.fragment.getActivity().finish();
        }
    }

    private void openNewLink(WebView webView, String params) {
        try {
            JSONObject jsonObject = new JSONObject(params);
            if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("url"))) {
                webView.loadUrl(jsonObject.optString("url"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFullScreen(boolean isFullScreen) {
        if (this.fragment != null && this.fragment.getActivity() != null) {
            Window window = this.fragment.getActivity().getWindow();
            window.setFlags(isFullScreen ? 1024 : 2048, 1024);
        }
    }

    private void updateScreenOrientation(String targetOrientation) {
        int orientation = 4;
        if (CONFIG_ORIENTATION_PORTRAIT.equals(targetOrientation)) {
            orientation = 1;
        } else if (CONFIG_ORIENTATION_LANDSCAPE.equals(targetOrientation)) {
            orientation = 0;
        }
        if (this.fragment != null && this.fragment.getActivity() != null) {
            this.fragment.getActivity().setRequestedOrientation(orientation);
        }
    }

    public void callJs(String json) {
        StringBuilder jsHandler = new StringBuilder("INTLJSHandler");
        jsHandler.append("('").append(json).append("')");
    }

    public static AIHelpJSBridge getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final AIHelpJSBridge INSTANCE = new AIHelpJSBridge();

        private Holder() {
        }
    }
}

