/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import androidx.fragment.app.Fragment;
import java.io.File;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.data.attachment.AttachmentHelper;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.webkit.AIHelpWebProgress;

public class AIHelpWebChromeClient
extends WebChromeClient {
    private final Fragment fragment;
    private final AIHelpWebProgress webProgress;
    private Window window;
    private ViewGroup fullScreenContainer;
    private ValueCallback<Uri> mUploadMessage;
    private ValueCallback<Uri[]> mUploadCallbackAboveL;
    public static final int REQUEST_CODE = 1;
    private View mCustomView = null;

    public AIHelpWebChromeClient(Fragment fragment, AIHelpWebProgress webProgress) {
        this.fragment = fragment;
        this.webProgress = webProgress;
        if (fragment != null && fragment.getActivity() != null) {
            this.window = fragment.getActivity().getWindow();
            this.fullScreenContainer = (ViewGroup)this.window.getDecorView().findViewById(0x1020002);
        }
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        super.onShowCustomView(view, callback);
        if (view != null && this.fullScreenContainer != null) {
            this.mCustomView = view;
            this.mCustomView.setBackgroundColor(Color.parseColor((String)"#000000"));
            this.fullScreenContainer.addView(this.mCustomView);
            this.window.setFlags(1024, 1024);
        }
    }

    public void onHideCustomView() {
        super.onHideCustomView();
        if (this.mCustomView != null && this.fullScreenContainer != null) {
            this.fullScreenContainer.removeView(this.mCustomView);
            this.mCustomView = null;
            WindowManager.LayoutParams attrs = this.window.getAttributes();
            attrs.flags &= 0xFFFFFBFF;
            this.window.setAttributes(attrs);
            this.window.clearFlags(512);
        }
    }

    public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
        if (!TextUtils.isEmpty((CharSequence)title) && !"AIHelp".equals(title) && !"about:blank".equals(title) && this.fragment instanceof IntentUrlFragment) {
            EventBus.getDefault().post(new UpdateTitleEvent(title));
        }
    }

    public void onProgressChanged(WebView view, int newProgress) {
        super.onProgressChanged(view, newProgress);
        this.webProgress.setProgress(newProgress);
    }

    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        this.mUploadCallbackAboveL = filePathCallback;
        this.tryGetFileFromData();
        return true;
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg) {
        this.mUploadMessage = uploadMsg;
        this.tryGetFileFromData();
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
        this.mUploadMessage = uploadMsg;
        this.tryGetFileFromData();
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
        this.mUploadMessage = uploadMsg;
        this.tryGetFileFromData();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            if (requestCode == 1) {
                Uri result;
                if (null == this.mUploadMessage && null == this.mUploadCallbackAboveL) {
                    return;
                }
                Uri uri = result = data == null || resultCode != -1 ? null : data.getData();
                if (this.mUploadCallbackAboveL != null) {
                    Uri[] results = null;
                    File copiedUriFile = AttachmentHelper.getCopiedUriFile(AIHelpContext.getInstance().getContext(), result);
                    if (copiedUriFile != null) {
                        results = new Uri[]{Uri.fromFile((File)copiedUriFile)};
                    }
                    this.mUploadCallbackAboveL.onReceiveValue(results);
                    this.mUploadCallbackAboveL = null;
                } else if (this.mUploadMessage != null) {
                    if (result != null) {
                        File copiedUriFile = AttachmentHelper.getCopiedUriFile(AIHelpContext.getInstance().getContext(), result);
                        Uri uri2 = null;
                        if (copiedUriFile != null) {
                            uri2 = Uri.fromFile((File)copiedUriFile);
                        }
                        this.mUploadMessage.onReceiveValue((Object)uri2);
                    } else {
                        this.mUploadMessage.onReceiveValue(null);
                    }
                    this.mUploadMessage = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelChooseFileDialog() {
        if (null != this.mUploadCallbackAboveL) {
            this.mUploadCallbackAboveL.onReceiveValue(null);
            this.mUploadCallbackAboveL = null;
        }
        if (null != this.mUploadMessage) {
            this.mUploadMessage.onReceiveValue(null);
            this.mUploadMessage = null;
        }
    }

    @TargetApi(value=1)
    private void onActivityResultAboveL(int requestCode, int resultCode, Intent data) {
        if (requestCode != 1 || this.mUploadCallbackAboveL == null) {
            return;
        }
        Uri[] results = null;
        if (resultCode == -1 && data != null) {
            String dataString = data.getDataString();
            ClipData clipData = null;
            if (Build.VERSION.SDK_INT >= 16) {
                clipData = data.getClipData();
            }
            if (clipData != null) {
                results = new Uri[clipData.getItemCount()];
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    ClipData.Item item = clipData.getItemAt(i);
                    results[i] = item.getUri();
                }
            }
            if (dataString != null) {
                results = new Uri[]{Uri.parse((String)dataString)};
            }
        }
        if (results != null) {
            this.mUploadCallbackAboveL.onReceiveValue(results);
            this.mUploadCallbackAboveL = null;
        } else {
            this.mUploadCallbackAboveL.onReceiveValue(null);
            this.mUploadCallbackAboveL = null;
        }
    }

    private void tryGetFileFromData() {
        String[] permissionArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
        if (Build.VERSION.SDK_INT >= 33) {
            permissionArray = new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"};
        }
        AIHelpPermissions.getInstance().setPermissionHandler(this.fragment).setRequestCode(1001).setRequestPermission(permissionArray).request(this.fragment.getContext(), 1);
    }
}

