/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import net.aihelp.common.CustomConfig;
import net.aihelp.utils.Styles;

public class AIHelpWebProgress
extends FrameLayout {
    public static final int MAX_UNIFORM_SPEED_DURATION = 8000;
    public static final int MAX_DECELERATE_SPEED_DURATION = 450;
    public static final int DO_END_ALPHA_DURATION = 630;
    public static final int DO_END_PROGRESS_DURATION = 500;
    private static int CURRENT_MAX_UNIFORM_SPEED_DURATION = 8000;
    private static int CURRENT_MAX_DECELERATE_SPEED_DURATION = 450;
    public static int WEB_PROGRESS_DEFAULT_HEIGHT = 3;
    public static String WEB_PROGRESS_COLOR = "#2483D9";
    private int mColor;
    private Paint mPaint;
    private Animator mAnimator;
    private int mTargetWidth = 0;
    private int mTargetHeight;
    private int TAG = 0;
    private boolean isShow = false;
    public static final int UN_START = 0;
    public static final int STARTED = 1;
    public static final int FINISH = 2;
    private float mCurrentProgress = 0.0f;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            AIHelpWebProgress.this.mCurrentProgress = ((Float)animation.getAnimatedValue()).floatValue();
            AIHelpWebProgress.this.invalidate();
        }
    };
    private AnimatorListenerAdapter mAnimatorListenerAdapter = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            AIHelpWebProgress.this.doEnd();
        }
    };

    public AIHelpWebProgress(Context context) {
        this(context, null);
    }

    public AIHelpWebProgress(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpWebProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mPaint = new Paint();
        this.mColor = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mTargetWidth = Styles.getScreenWidth(context);
        this.mTargetHeight = this.dip2px(WEB_PROGRESS_DEFAULT_HEIGHT);
    }

    public void setColor(int color) {
        this.mColor = color;
        this.mPaint.setColor(color);
    }

    public void setColor(String color) {
        this.setColor(Color.parseColor((String)color));
    }

    public void setColor(int startColor, int endColor) {
        LinearGradient linearGradient = new LinearGradient(0.0f, 0.0f, (float)this.mTargetWidth, (float)this.mTargetHeight, startColor, endColor, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)linearGradient);
    }

    public void setColor(String startColor, String endColor) {
        this.setColor(Color.parseColor((String)startColor), Color.parseColor((String)endColor));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (wMode == Integer.MIN_VALUE) {
            w = Math.min(w, Styles.getScreenWidth(this.getContext()));
        }
        if (hMode == Integer.MIN_VALUE) {
            h = this.mTargetHeight;
        }
        this.setMeasuredDimension(w, h);
    }

    protected void onDraw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
        if (Styles.isLayoutRtl((View)this)) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        canvas.drawRect(0.0f, 0.0f, this.mCurrentProgress / 100.0f * Float.valueOf(this.getWidth()).floatValue(), (float)this.getHeight(), this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mTargetWidth = this.getMeasuredWidth();
        int screenWidth = Styles.getScreenWidth(this.getContext());
        if (this.mTargetWidth >= screenWidth) {
            CURRENT_MAX_DECELERATE_SPEED_DURATION = 450;
            CURRENT_MAX_UNIFORM_SPEED_DURATION = 8000;
        } else {
            float rate = (float)this.mTargetWidth / (float)screenWidth;
            CURRENT_MAX_UNIFORM_SPEED_DURATION = (int)(8000.0f * rate);
            CURRENT_MAX_DECELERATE_SPEED_DURATION = (int)(450.0f * rate);
        }
    }

    private void setFinish() {
        this.isShow = false;
        this.TAG = 2;
    }

    private void startAnim(boolean isFinished) {
        float v;
        float f = v = isFinished ? 100.0f : 95.0f;
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
        }
        float f2 = this.mCurrentProgress = this.mCurrentProgress == 0.0f ? 1.0E-8f : this.mCurrentProgress;
        if (!isFinished) {
            ValueAnimator mAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentProgress, v});
            float residue = 1.0f - this.mCurrentProgress / 100.0f - 0.05f;
            mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            mAnimator.setDuration((long)(residue * (float)CURRENT_MAX_UNIFORM_SPEED_DURATION));
            mAnimator.addUpdateListener(this.mAnimatorUpdateListener);
            mAnimator.start();
            this.mAnimator = mAnimator;
        } else {
            ValueAnimator segment95Animator = null;
            if (this.mCurrentProgress < 95.0f) {
                segment95Animator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentProgress, 95.0f});
                float residue = 1.0f - this.mCurrentProgress / 100.0f - 0.05f;
                segment95Animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                segment95Animator.setDuration((long)(residue * (float)CURRENT_MAX_DECELERATE_SPEED_DURATION));
                segment95Animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                segment95Animator.addUpdateListener(this.mAnimatorUpdateListener);
            }
            ObjectAnimator mObjectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            mObjectAnimator.setDuration(630L);
            ValueAnimator mValueAnimatorEnd = ValueAnimator.ofFloat((float[])new float[]{95.0f, 100.0f});
            mValueAnimatorEnd.setDuration(500L);
            mValueAnimatorEnd.addUpdateListener(this.mAnimatorUpdateListener);
            AnimatorSet mAnimatorSet = new AnimatorSet();
            mAnimatorSet.playTogether(new Animator[]{mObjectAnimator, mValueAnimatorEnd});
            if (segment95Animator != null) {
                AnimatorSet mAnimatorSet1 = new AnimatorSet();
                mAnimatorSet1.play((Animator)mAnimatorSet).after((Animator)segment95Animator);
                mAnimatorSet = mAnimatorSet1;
            }
            mAnimatorSet.addListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
            mAnimatorSet.start();
            this.mAnimator = mAnimatorSet;
        }
        this.TAG = 1;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    private void doEnd() {
        if (this.TAG == 2 && this.mCurrentProgress == 100.0f) {
            this.setVisibility(8);
            this.mCurrentProgress = 0.0f;
            this.setAlpha(1.0f);
        }
        this.TAG = 0;
    }

    public void reset() {
        this.mCurrentProgress = 0.0f;
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
        }
    }

    public void setProgress(int newProgress) {
        this.setProgress(Float.valueOf(newProgress).floatValue());
    }

    public FrameLayout.LayoutParams offerLayoutParams() {
        return new FrameLayout.LayoutParams(this.mTargetWidth, this.mTargetHeight);
    }

    private int dip2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setProgress(float progress) {
        if (this.TAG == 0 && progress == 100.0f) {
            this.setVisibility(8);
            return;
        }
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
        }
        if (progress < 95.0f) {
            return;
        }
        if (this.TAG != 2) {
            this.startAnim(true);
        }
    }

    public void show() {
        this.isShow = true;
        this.setVisibility(0);
        this.mCurrentProgress = 0.0f;
        this.startAnim(false);
    }

    public void hide() {
        this.setWebProgress(100);
    }

    public void setWebProgress(int newProgress) {
        if (newProgress >= 0 && newProgress < 95) {
            if (!this.isShow) {
                this.show();
            } else {
                this.setProgress(newProgress);
            }
        } else {
            this.setProgress(newProgress);
            this.setFinish();
        }
    }
}

