/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.webkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import net.aihelp.common.Const;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.TLog;

public class AIHelpWebViewClient
extends WebViewClient {
    public static final String TAG = AIHelpWebViewClient.class.getSimpleName();
    private Context context;
    private AIHelpWebProgress webProgress;
    private ShouldOverrideUrlLoadingListener mUrlLoadingListener;
    private OnPageLoadingProgressListener mPageLoadingProgressListener;
    private boolean openInNewWindow;

    public void setOpenInNewWindow(boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public void setOnPageLoadingProgressListener(OnPageLoadingProgressListener mPageLoadingProgressListener) {
        this.mPageLoadingProgressListener = mPageLoadingProgressListener;
    }

    public void setUrlLoadingListener(ShouldOverrideUrlLoadingListener mUrlLoadingListener) {
        this.mUrlLoadingListener = mUrlLoadingListener;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress) {
        this.context = context;
        this.webProgress = webProgress;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress, boolean openInNewWindow) {
        this.context = context;
        this.webProgress = webProgress;
        this.openInNewWindow = openInNewWindow;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        boolean ret;
        boolean bl = ret = Build.VERSION.SDK_INT >= 24 && this.handleUrlClickAndCancelCurrentLoad(view, request.getUrl().toString()) || super.shouldOverrideUrlLoading(view, request);
        if (this.mUrlLoadingListener != null) {
            this.mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        boolean ret;
        boolean bl = ret = Build.VERSION.SDK_INT < 24 && this.handleUrlClickAndCancelCurrentLoad(view, url) || super.shouldOverrideUrlLoading(view, url);
        if (this.mUrlLoadingListener != null) {
            this.mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.webProgress.show();
        if (this.mPageLoadingProgressListener != null) {
            this.mPageLoadingProgressListener.onPageStarted(view, url);
        }
        if (!TextUtils.isEmpty((CharSequence)url) && !"about:blank".equals(url)) {
            TLog.d("AIHelpWebView", "\u5f00\u59cb --- " + url);
            EventTracker.INSTANCE.log(318, url);
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (view.getProgress() == 100) {
            if (this.mPageLoadingProgressListener != null) {
                this.mPageLoadingProgressListener.onPageFinished(view, url);
            }
            if (!TextUtils.isEmpty((CharSequence)url) && !"about:blank".equals(url)) {
                EventTracker.INSTANCE.log(403, url);
                TLog.d("AIHelpWebViewClient", "\u7ed3\u675f WEB_LOAD_FINISHED --- " + url);
            }
        }
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    private boolean handleUrlClickAndCancelCurrentLoad(WebView view, String url) {
        if (AppInfoUtil.isUrlStillNeedResponding(this.context, url) && this.openInNewWindow) {
            Bundle bundle = new Bundle();
            bundle.putString("intent_url", url);
            EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
            return true;
        }
        boolean isDeepLink = !TextUtils.isEmpty((CharSequence)url) && !url.startsWith("http");
        boolean isSpecialUrl = !TextUtils.isEmpty((CharSequence)url) && url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null;
        return isDeepLink || isSpecialUrl;
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String message;
        super.onReceivedSslError(view, handler, error);
        switch (error.getPrimaryError()) {
            case 4: {
                message = "SSL_DATE_INVALID";
                break;
            }
            case 1: {
                message = "SSL_EXPIRED";
                break;
            }
            case 2: {
                message = "SSL_IDMISMATCH";
                break;
            }
            case 5: {
                message = "SSL_INVALID";
                break;
            }
            case 0: {
                message = "SSL_NOTYETVALID";
                break;
            }
            case 3: {
                message = "SSL_UNTRUSTED";
                break;
            }
            default: {
                message = "SslError unknown";
            }
        }
        Log.d((String)TAG, (String)("onReceivedSslError: " + message));
    }

    public static interface OnPageLoadingProgressListener {
        public void onPageStarted(WebView var1, String var2);

        public void onPageFinished(WebView var1, String var2);
    }

    public static interface ShouldOverrideUrlLoadingListener {
        public void handleUrlClick(boolean var1);
    }
}

