/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.TemplateReadyEvent;
import net.aihelp.utils.Styles;

public class AIHelpButton
extends RelativeLayout {
    public AIHelpButton(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
        TextView textView = new TextView(context);
        RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        textViewLayoutParams.addRule(13);
        if (Styles.isLayoutRtl((View)this)) {
            textViewLayoutParams.addRule(9);
            if (Build.VERSION.SDK_INT >= 17) {
                textViewLayoutParams.addRule(20);
            }
        }
        textView.setLayoutParams((ViewGroup.LayoutParams)textViewLayoutParams);
        textView.setGravity(17);
        textView.setMinWidth(Styles.dpToPx(context, 84.0f));
        textView.setMinHeight(Styles.dpToPx(context, 28.0f));
        textView.setBackground((Drawable)Styles.getClickableDrawableForButton());
        textView.setMaxLines(1);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        Styles.reRenderTextView(textView, "", -1);
        textView.setPadding(Styles.dpToPx(context, 12.0f), Styles.dpToPx(context, 7.0f), Styles.dpToPx(context, 12.0f), Styles.dpToPx(context, 7.0f));
        textView.setMaxWidth((int)((float)Styles.getScreenWidth(this.getContext()) * 0.8f));
        this.addView((View)textView);
    }

    public AIHelpButton setText(String text) {
        View view = this.getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            textView.setText((CharSequence)text);
        }
        return this;
    }

    public AIHelpButton setMaxWidth(int maxWidth) {
        View view = this.getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            textView.setMaxWidth(maxWidth);
        }
        return this;
    }

    public AIHelpButton setFullWidth() {
        View view = this.getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            ViewGroup.LayoutParams layoutParams = textView.getLayoutParams();
            layoutParams.width = -1;
            textView.setLayoutParams(layoutParams);
        }
        return this;
    }

    public String getText() {
        View view = this.getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            return textView.getText().toString();
        }
        return "";
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register((Object)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onTemplateReady(TemplateReadyEvent templateReadyEvent) {
        this.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
        View view = this.getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            textView.setBackground((Drawable)Styles.getClickableDrawableForButton());
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof TemplateReadyEvent) {
            this.setBackground(Styles.getDrawable(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor), 8));
            View view = this.getChildAt(0);
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                textView.setBackground((Drawable)Styles.getClickableDrawableForButton());
            }
        }
        if (event instanceof OrientationChangeEvent) {
            this.setMaxWidth((int)((float)Styles.getScreenWidth(this.getContext()) * 0.8f));
        }
    }
}

