/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Iterator;
import net.aihelp.common.API;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class AIHelpEvaluateButtonView
extends FrameLayout
implements View.OnClickListener {
    public static final int STATE_NORMAL = 1;
    public static final int STATE_INVISIBLE = 2;
    public static final int STATE_HELPFUL = 3;
    public static final int STATE_UNHELPFUL = 4;
    private final AIHelpButton mBtnUnHelpful;
    private final AIHelpButton mBtnHelpful;
    private final TextView mTvShowThanks;
    private int minWidth;
    private int maxWidth;
    private OnAIHelpEvaluateViewCallback listener;

    public int getMinWidth() {
        return this.minWidth;
    }

    private void resetEvaluateState() {
        this.setVisibility(0);
        this.mBtnHelpful.setVisibility(0);
        this.mBtnUnHelpful.setVisibility(0);
        this.mTvShowThanks.setVisibility(8);
    }

    private void setEvaluateState(int evaluateState) {
        this.resetEvaluateState();
        switch (evaluateState) {
            case 1: {
                int buttonWidth = Math.max(this.mBtnUnHelpful.getMeasuredWidth(), this.mBtnHelpful.getMeasuredWidth());
                this.minWidth = buttonWidth * 2 + Styles.dpToPx(this.getContext(), 20.0f);
                if (this.maxWidth > 0 && buttonWidth * 2 + Styles.dpToPx(this.getContext(), 20.0f) > this.maxWidth) {
                    buttonWidth = (this.maxWidth - Styles.dpToPx(this.getContext(), 20.0f)) / 2;
                }
                ViewGroup.LayoutParams unHelpfulParams = this.mBtnUnHelpful.getLayoutParams();
                unHelpfulParams.width = buttonWidth;
                this.mBtnUnHelpful.setLayoutParams(unHelpfulParams);
                ViewGroup.LayoutParams helpfulParams = this.mBtnHelpful.getLayoutParams();
                helpfulParams.width = buttonWidth;
                this.mBtnHelpful.setLayoutParams(helpfulParams);
                break;
            }
            case 2: {
                this.setVisibility(8);
                break;
            }
            case 3: 
            case 4: {
                this.mBtnHelpful.setVisibility(8);
                this.mBtnUnHelpful.setVisibility(8);
                this.mTvShowThanks.setVisibility(0);
                if (evaluateState == 3) {
                    Styles.reRenderTextView(this.mTvShowThanks, CustomConfig.InitSetting.commonPositiveFeedbackHint, 0.5f);
                } else {
                    Styles.reRenderTextView(this.mTvShowThanks, CustomConfig.InitSetting.commonNegativeFeedbackHint, 0.5f);
                }
                this.mTvShowThanks.measure(0, 0);
                this.minWidth = this.mTvShowThanks.getMeasuredWidth();
            }
        }
    }

    public void setOnAIHelpEvaluateViewCallback(OnAIHelpEvaluateViewCallback listener) {
        this.listener = listener;
    }

    public AIHelpEvaluateButtonView(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpEvaluateButtonView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpEvaluateButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View rootView = View.inflate((Context)context, (int)ResResolver.getLayoutId("aihelp_evaluate_button_view"), (ViewGroup)this);
        this.mBtnUnHelpful = (AIHelpButton)rootView.findViewById(ResResolver.getViewId("aihelp_btn_un_helpful"));
        this.mBtnUnHelpful.setText(ResResolver.getString("aihelp_faq_unhelpful"));
        this.mBtnUnHelpful.measure(0, 0);
        this.mBtnHelpful = (AIHelpButton)rootView.findViewById(ResResolver.getViewId("aihelp_btn_helpful"));
        this.mBtnHelpful.setText(ResResolver.getString("aihelp_faq_helpful"));
        this.mBtnHelpful.measure(0, 0);
        this.mTvShowThanks = (TextView)rootView.findViewById(ResResolver.getViewId("aihelp_tv_thanks"));
        this.mBtnUnHelpful.setOnClickListener(this);
        this.mBtnHelpful.setOnClickListener(this);
    }

    public void refreshViewState(int userFeedback) {
        if (CustomConfig.InitSetting.isEvaluationForBotEnable) {
            switch (userFeedback) {
                case -1: {
                    this.setEvaluateState(2);
                    break;
                }
                case 0: {
                    this.setEvaluateState(1);
                    break;
                }
                case 1: {
                    this.setEvaluateState(3);
                    break;
                }
                case 2: {
                    this.setEvaluateState(4);
                }
            }
        } else {
            this.setEvaluateState(2);
        }
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_btn_un_helpful")) {
            this.setEvaluateState(4);
            this.postHelpfulStatusForAnswerBot(false);
        }
        if (v.getId() == ResResolver.getViewId("aihelp_btn_helpful")) {
            this.setEvaluateState(3);
            this.postHelpfulStatusForAnswerBot(true);
        }
    }

    private void postHelpfulStatusForAnswerBot(boolean helpful) {
        if (this.listener != null) {
            this.listener.onEvaluated(helpful);
        }
        try {
            JSONObject params = new JSONObject();
            params.put("type", (Object)(helpful ? "like" : "unlike"));
            if (this.listener != null && this.listener.requestDataForFeedback() != null) {
                JSONObject dataForFeedback = this.listener.requestDataForFeedback();
                Iterator keys = dataForFeedback.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    params.put(key, dataForFeedback.opt(key));
                }
            }
            AIHelpRequest.getInstance().requestPostByJson(API.EVALUATE_ANSWER_BOT_FAQ, params, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public static abstract class OnAIHelpEvaluateViewCallback {
        public void onEvaluated(boolean isHelpful) {
        }

        public JSONObject requestDataForFeedback() {
            return null;
        }
    }
}

