/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AIHelpFlowLayout
extends ViewGroup {
    private final Context mContext;
    private int usefulWidth;
    private int lineSpacing = 0;
    List<View> childList = new ArrayList<View>();
    List<Integer> lineNumList = new ArrayList<Integer>();
    private OnLabelClickedListener mListener;

    public AIHelpFlowLayout(Context context) {
        this(context, null);
    }

    public AIHelpFlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        int[] styleable = ResResolver.getStyleable("aihelp_flow_layout");
        if (styleable != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(styleable);
            this.lineSpacing = array.getColor(ResResolver.getStyleableFieldIndex("aihelp_flow_layout", "aihelp_flow_layout_lineSpacing"), Styles.dpToPx(context, 12.0f));
            array.recycle();
        }
    }

    public void setOnLabelClickedListener(OnLabelClickedListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int mPaddingTop = this.getPaddingTop();
        int mPaddingBottom = this.getPaddingBottom();
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int lineUsed = mPaddingLeft + mPaddingRight;
        int lineY = mPaddingTop;
        int lineHeight = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int spaceWidth = 0;
            int spaceHeight = 0;
            ViewGroup.LayoutParams childLp = child.getLayoutParams();
            if (childLp instanceof ViewGroup.MarginLayoutParams) {
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, lineY);
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)childLp;
                spaceWidth = mlp.leftMargin + mlp.rightMargin;
                spaceHeight = mlp.topMargin + mlp.bottomMargin;
            } else {
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            }
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            spaceHeight += childHeight;
            if (lineUsed + (spaceWidth += childWidth) > widthSize) {
                lineY += lineHeight + this.lineSpacing;
                lineUsed = mPaddingLeft + mPaddingRight;
                lineHeight = 0;
            }
            if (spaceHeight > lineHeight) {
                lineHeight = spaceHeight;
            }
            lineUsed += spaceWidth;
        }
        this.setMeasuredDimension(widthSize, heightMode == 0x40000000 ? heightSize : lineY + lineHeight + mPaddingBottom);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int mPaddingLeft = this.getPaddingLeft();
        int mPaddingRight = this.getPaddingRight();
        int mPaddingTop = this.getPaddingTop();
        int lineX = mPaddingLeft;
        int lineY = mPaddingTop;
        int lineWidth = r - l;
        this.usefulWidth = lineWidth - mPaddingLeft - mPaddingRight;
        int lineUsed = mPaddingLeft + mPaddingRight;
        int lineHeight = 0;
        int lineNum = 0;
        this.lineNumList.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ViewGroup.MarginLayoutParams mlp;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int spaceWidth = 0;
            int spaceHeight = 0;
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.LayoutParams childLp = child.getLayoutParams();
            if (childLp instanceof ViewGroup.MarginLayoutParams) {
                mlp = (ViewGroup.MarginLayoutParams)childLp;
                spaceWidth = mlp.leftMargin + mlp.rightMargin;
                spaceHeight = mlp.topMargin + mlp.bottomMargin;
                left = lineX + mlp.leftMargin;
                top = lineY + mlp.topMargin;
                right = lineX + mlp.leftMargin + childWidth;
                bottom = lineY + mlp.topMargin + childHeight;
            } else {
                left = lineX;
                top = lineY;
                right = lineX + childWidth;
                bottom = lineY + childHeight;
            }
            spaceHeight += childHeight;
            if (lineUsed + (spaceWidth += childWidth) > lineWidth) {
                this.lineNumList.add(lineNum);
                lineY += lineHeight + this.lineSpacing;
                lineUsed = mPaddingLeft + mPaddingRight;
                lineX = mPaddingLeft;
                lineHeight = 0;
                lineNum = 0;
                if (childLp instanceof ViewGroup.MarginLayoutParams) {
                    mlp = (ViewGroup.MarginLayoutParams)childLp;
                    left = lineX + mlp.leftMargin;
                    top = lineY + mlp.topMargin;
                    right = lineX + mlp.leftMargin + childWidth;
                    bottom = lineY + mlp.topMargin + childHeight;
                } else {
                    left = lineX;
                    top = lineY;
                    right = lineX + childWidth;
                    bottom = lineY + childHeight;
                }
            }
            child.layout(left, top, right, bottom);
            ++lineNum;
            if (spaceHeight > lineHeight) {
                lineHeight = spaceHeight;
            }
            lineUsed += spaceWidth;
            lineX += spaceWidth;
        }
        this.lineNumList.add(lineNum);
    }

    public void update(List<RPAStep.Action> actionList, boolean tightLayout) {
        if (actionList != null) {
            this.removeAllViews();
            for (final RPAStep.Action action : actionList) {
                if (action == null || TextUtils.isEmpty((CharSequence)action.getContent())) continue;
                ViewGroup.MarginLayoutParams lp = new ViewGroup.MarginLayoutParams(-2, -2);
                lp.setMargins(0, 0, this.dpToPx(12.0f), 0);
                TextView tv = new TextView(this.getContext());
                tv.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1), 3));
                Styles.reRenderTextView(tv, action.getContent(), Color.parseColor((String)CustomConfig.CommonSetting.textColor), true, 13);
                tv.setPadding(this.dpToPx(6.0f), this.dpToPx(4.0f), this.dpToPx(6.0f), this.dpToPx(4.0f));
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AIHelpFlowLayout.this.mListener != null) {
                            AIHelpFlowLayout.this.mListener.onLabelClicked(action);
                        }
                    }
                });
                this.addView((View)tv, (ViewGroup.LayoutParams)lp);
            }
        }
        if (tightLayout) {
            this.relayoutToCompressAndAlign();
        }
    }

    public void relayoutToCompress() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIHelpFlowLayout.this.compress();
            }
        });
    }

    private void compress() {
        int childCount = this.getChildCount();
        if (0 == childCount) {
            return;
        }
        int count = 0;
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (v instanceof BlankView) continue;
            ++count;
        }
        View[] childs = new View[count];
        int[] spaces = new int[count];
        int n = 0;
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (v instanceof BlankView) continue;
            childs[n] = v;
            ViewGroup.LayoutParams childLp = v.getLayoutParams();
            int childWidth = v.getMeasuredWidth();
            if (childLp instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)childLp;
                spaces[n] = mlp.leftMargin + childWidth + mlp.rightMargin;
            } else {
                spaces[n] = childWidth;
            }
            ++n;
        }
        int[] compressSpaces = new int[count];
        for (int i = 0; i < count; ++i) {
            compressSpaces[i] = Math.min(spaces[i], this.usefulWidth);
        }
        this.sortToCompress(childs, compressSpaces);
        this.removeAllViews();
        for (View v : this.childList) {
            this.addView(v);
        }
        this.childList.clear();
    }

    private void sortToCompress(View[] childs, int[] spaces) {
        int i;
        int childCount = childs.length;
        int[][] table = new int[childCount + 1][this.usefulWidth + 1];
        for (int i2 = 0; i2 < childCount + 1; ++i2) {
            for (int j = 0; j < this.usefulWidth; ++j) {
                table[i2][j] = 0;
            }
        }
        boolean[] flag = new boolean[childCount];
        for (i = 0; i < childCount; ++i) {
            flag[i] = false;
        }
        for (i = 1; i <= childCount; ++i) {
            for (int j = spaces[i - 1]; j <= this.usefulWidth; ++j) {
                table[i][j] = Math.max(table[i - 1][j], table[i - 1][j - spaces[i - 1]] + spaces[i - 1]);
            }
        }
        int v = this.usefulWidth;
        for (int i3 = childCount; i3 > 0 && v >= spaces[i3 - 1]; --i3) {
            if (table[i3][v] != table[i3 - 1][v - spaces[i3 - 1]] + spaces[i3 - 1]) continue;
            flag[i3 - 1] = true;
            v -= spaces[i3 - 1];
        }
        int rest = childCount;
        for (int i4 = 0; i4 < flag.length; ++i4) {
            if (!flag[i4]) continue;
            this.childList.add(childs[i4]);
            --rest;
        }
        if (0 == rest) {
            return;
        }
        View[] restArray = new View[rest];
        int[] restSpaces = new int[rest];
        int index = 0;
        for (int i5 = 0; i5 < flag.length; ++i5) {
            if (flag[i5]) continue;
            restArray[index] = childs[i5];
            restSpaces[index] = spaces[i5];
            ++index;
        }
        table = null;
        childs = null;
        flag = null;
        this.sortToCompress(restArray, restSpaces);
    }

    public void relayoutToAlign() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIHelpFlowLayout.this.align();
            }
        });
    }

    private void align() {
        int i;
        int childCount = this.getChildCount();
        if (0 == childCount) {
            return;
        }
        int count = 0;
        for (int i2 = 0; i2 < childCount; ++i2) {
            View v = this.getChildAt(i2);
            if (v instanceof BlankView) continue;
            ++count;
        }
        View[] childs = new View[count];
        int[] spaces = new int[count];
        int n = 0;
        for (int i3 = 0; i3 < childCount; ++i3) {
            View v = this.getChildAt(i3);
            if (v instanceof BlankView) continue;
            childs[n] = v;
            ViewGroup.LayoutParams childLp = v.getLayoutParams();
            int childWidth = v.getMeasuredWidth();
            if (childLp instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)childLp;
                spaces[n] = mlp.leftMargin + childWidth + mlp.rightMargin;
            } else {
                spaces[n] = childWidth;
            }
            ++n;
        }
        int lineTotal = 0;
        int start = 0;
        this.removeAllViews();
        for (i = 0; i < count; ++i) {
            if (lineTotal + spaces[i] > this.usefulWidth) {
                int blankWidth = this.usefulWidth - lineTotal;
                int end = i - 1;
                int blankCount = end - start;
                if (blankCount >= 0) {
                    if (blankCount > 0) {
                        int eachBlankWidth = blankWidth / blankCount;
                        ViewGroup.MarginLayoutParams lp = new ViewGroup.MarginLayoutParams(eachBlankWidth, 0);
                        for (int j = start; j < end; ++j) {
                            this.addView(childs[j]);
                            BlankView blank = new BlankView(this.mContext);
                            this.addView(blank, (ViewGroup.LayoutParams)lp);
                        }
                    }
                    this.addView(childs[end]);
                    start = i--;
                    lineTotal = 0;
                    continue;
                }
                this.addView(childs[i]);
                start = i + 1;
                lineTotal = 0;
                continue;
            }
            lineTotal += spaces[i];
        }
        for (i = start; i < count; ++i) {
            this.addView(childs[i]);
        }
    }

    public void relayoutToCompressAndAlign() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AIHelpFlowLayout.this.compress();
                AIHelpFlowLayout.this.align();
            }
        });
    }

    public void specifyLines(final int line_num_now) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int line_num = line_num_now;
                int childNum = 0;
                if (line_num > AIHelpFlowLayout.this.lineNumList.size()) {
                    line_num = AIHelpFlowLayout.this.lineNumList.size();
                }
                for (int i = 0; i < line_num; ++i) {
                    childNum += AIHelpFlowLayout.this.lineNumList.get(i).intValue();
                }
                ArrayList<View> viewList = new ArrayList<View>();
                for (int i = 0; i < childNum; ++i) {
                    viewList.add(AIHelpFlowLayout.this.getChildAt(i));
                }
                AIHelpFlowLayout.this.removeAllViews();
                for (View v : viewList) {
                    AIHelpFlowLayout.this.addView(v);
                }
            }
        });
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(super.generateDefaultLayoutParams());
    }

    public int dpToPx(float dp) {
        return (int)(dp * this.getContext().getResources().getDisplayMetrics().density);
    }

    public static interface OnLabelClickedListener {
        public void onLabelClicked(RPAStep.Action var1);
    }

    static class BlankView
    extends View {
        public BlankView(Context context) {
            super(context);
        }
    }
}

