/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.widget.snackbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.ui.widget.snackbar.SnackbarContentLayout;
import net.aihelp.ui.widget.snackbar.SnackbarManager;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public abstract class BaseTransientBottomBar<B extends BaseTransientBottomBar<B>> {
    public static final int ANIMATION_MODE_SLIDE = 0;
    public static final int ANIMATION_MODE_FADE = 1;
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    static final int ANIMATION_DURATION = 250;
    static final int ANIMATION_FADE_DURATION = 180;
    private static final int ANIMATION_FADE_IN_DURATION = 150;
    private static final int ANIMATION_FADE_OUT_DURATION = 75;
    private static final float ANIMATION_SCALE_FROM_VALUE = 0.8f;
    @NonNull
    static final Handler handler;
    static final int MSG_SHOW = 0;
    static final int MSG_DISMISS = 1;
    private static final boolean USE_OFFSET_API;
    private static final String TAG;
    @NonNull
    private final ViewGroup targetParent;
    private final Context context;
    @NonNull
    protected final SnackbarBaseLayout view;
    @NonNull
    private final net.aihelp.ui.widget.snackbar.ContentViewCallback contentViewCallback;
    private int duration;
    private boolean gestureInsetBottomIgnored;
    @Nullable
    private View anchorView;
    @RequiresApi(value=29)
    private final Runnable bottomMarginGestureInsetRunnable = new Runnable(){

        @Override
        public void run() {
            if (BaseTransientBottomBar.this.view == null || BaseTransientBottomBar.this.context == null) {
                return;
            }
            int currentInsetBottom = BaseTransientBottomBar.this.getScreenHeight() - BaseTransientBottomBar.this.getViewAbsoluteBottom() + (int)BaseTransientBottomBar.this.view.getTranslationY();
            if (currentInsetBottom >= BaseTransientBottomBar.this.extraBottomMarginGestureInset) {
                return;
            }
            ViewGroup.LayoutParams layoutParams = BaseTransientBottomBar.this.view.getLayoutParams();
            if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
                Log.w((String)TAG, (String)"Unable to apply gesture inset because layout params are not MarginLayoutParams");
                return;
            }
            ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)layoutParams;
            marginParams.bottomMargin += BaseTransientBottomBar.this.extraBottomMarginGestureInset - currentInsetBottom;
            BaseTransientBottomBar.this.view.requestLayout();
        }
    };
    @Nullable
    private Rect originalMargins;
    private int extraBottomMarginWindowInset;
    private int extraLeftMarginWindowInset;
    private int extraRightMarginWindowInset;
    private int extraBottomMarginGestureInset;
    private int extraBottomMarginAnchorView;
    private List<BaseCallback<B>> callbacks;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @NonNull
    SnackbarManager.Callback managerCallback = new SnackbarManager.Callback(){

        @Override
        public void show() {
            handler.sendMessage(handler.obtainMessage(0, (Object)BaseTransientBottomBar.this));
        }

        @Override
        public void dismiss(int event) {
            handler.sendMessage(handler.obtainMessage(1, event, 0, (Object)BaseTransientBottomBar.this));
        }
    };

    protected BaseTransientBottomBar(@NonNull ViewGroup parent, @NonNull View content, @NonNull net.aihelp.ui.widget.snackbar.ContentViewCallback contentViewCallback) {
        if (parent == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null parent");
        }
        if (content == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null content");
        }
        if (contentViewCallback == null) {
            throw new IllegalArgumentException("Transient bottom bar must have non-null callback");
        }
        this.targetParent = parent;
        this.contentViewCallback = contentViewCallback;
        this.context = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        this.view = (SnackbarBaseLayout)inflater.inflate(this.getSnackbarBaseLayoutResId(), this.targetParent, false);
        if (content instanceof SnackbarContentLayout) {
            ((SnackbarContentLayout)content).updateActionTextColorAlphaIfNeeded(this.view.getActionTextColorAlpha());
        }
        this.view.addView(content);
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)layoutParams;
            this.originalMargins = new Rect(marginParams.leftMargin, marginParams.topMargin, marginParams.rightMargin, marginParams.bottomMargin);
        }
        ViewCompat.setAccessibilityLiveRegion((View)this.view, (int)1);
        ViewCompat.setImportantForAccessibility((View)this.view, (int)1);
        ViewCompat.setFitsSystemWindows((View)this.view, (boolean)true);
        ViewCompat.setOnApplyWindowInsetsListener((View)this.view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View v, @NonNull WindowInsetsCompat insets) {
                BaseTransientBottomBar.this.extraBottomMarginWindowInset = insets.getSystemWindowInsetBottom();
                BaseTransientBottomBar.this.extraLeftMarginWindowInset = insets.getSystemWindowInsetLeft();
                BaseTransientBottomBar.this.extraRightMarginWindowInset = insets.getSystemWindowInsetRight();
                BaseTransientBottomBar.this.updateMargins();
                return insets;
            }
        });
        ViewCompat.setAccessibilityDelegate((View)this.view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.addAction(0x100000);
                info.setDismissable(true);
            }

            public boolean performAccessibilityAction(View host, int action, Bundle args) {
                if (action == 0x100000) {
                    BaseTransientBottomBar.this.dismiss();
                    return true;
                }
                return super.performAccessibilityAction(host, action, args);
            }
        });
        this.accessibilityManager = (AccessibilityManager)this.context.getSystemService("accessibility");
    }

    private void updateMargins() {
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (!(layoutParams instanceof ViewGroup.MarginLayoutParams) || this.originalMargins == null) {
            Log.w((String)TAG, (String)"Unable to update margins because layout params are not MarginLayoutParams");
            return;
        }
        int extraBottomMargin = this.anchorView != null ? this.extraBottomMarginAnchorView : this.extraBottomMarginWindowInset;
        ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)layoutParams;
        marginParams.bottomMargin = this.originalMargins.bottom + extraBottomMargin;
        marginParams.leftMargin = this.originalMargins.left + this.extraLeftMarginWindowInset;
        marginParams.rightMargin = this.originalMargins.right + this.extraRightMarginWindowInset;
        this.view.requestLayout();
        if (Build.VERSION.SDK_INT >= 29 && this.shouldUpdateGestureInset()) {
            this.view.removeCallbacks(this.bottomMarginGestureInsetRunnable);
            this.view.post(this.bottomMarginGestureInsetRunnable);
        }
    }

    private boolean shouldUpdateGestureInset() {
        return this.extraBottomMarginGestureInset > 0 && !this.gestureInsetBottomIgnored && this.isSwipeDismissable();
    }

    private boolean isSwipeDismissable() {
        return false;
    }

    @LayoutRes
    protected int getSnackbarBaseLayoutResId() {
        return ResResolver.getLayoutId("aihelp_design_layout_snackbar");
    }

    @NonNull
    public B setDuration(int duration) {
        this.duration = duration;
        return (B)this;
    }

    public int getDuration() {
        return this.duration;
    }

    @NonNull
    public B setGestureInsetBottomIgnored(boolean gestureInsetBottomIgnored) {
        this.gestureInsetBottomIgnored = gestureInsetBottomIgnored;
        return (B)this;
    }

    public boolean isGestureInsetBottomIgnored() {
        return this.gestureInsetBottomIgnored;
    }

    public int getAnimationMode() {
        return this.view.getAnimationMode();
    }

    @NonNull
    public B setAnimationMode(int animationMode) {
        this.view.setAnimationMode(animationMode);
        return (B)this;
    }

    @Nullable
    public View getAnchorView() {
        return this.anchorView;
    }

    @NonNull
    public B setAnchorView(@Nullable View anchorView) {
        this.anchorView = anchorView;
        return (B)this;
    }

    @NonNull
    public B setAnchorView(@IdRes int anchorViewId) {
        this.anchorView = this.targetParent.findViewById(anchorViewId);
        if (this.anchorView == null) {
            throw new IllegalArgumentException("Unable to find anchor view with id: " + anchorViewId);
        }
        return (B)this;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public View getView() {
        return this.view;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.getDuration(), this.managerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    protected void dispatchDismiss(int event) {
        SnackbarManager.getInstance().dismiss(this.managerCallback, event);
    }

    @NonNull
    public B addCallback(@Nullable BaseCallback<B> callback) {
        if (callback == null) {
            return (B)this;
        }
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<BaseCallback<B>>();
        }
        this.callbacks.add(callback);
        return (B)this;
    }

    @NonNull
    public B removeCallback(@Nullable BaseCallback<B> callback) {
        if (callback == null) {
            return (B)this;
        }
        if (this.callbacks == null) {
            return (B)this;
        }
        this.callbacks.remove(callback);
        return (B)this;
    }

    public boolean isShown() {
        return SnackbarManager.getInstance().isCurrent(this.managerCallback);
    }

    public boolean isShownOrQueued() {
        return SnackbarManager.getInstance().isCurrentOrNext(this.managerCallback);
    }

    final void showView() {
        this.view.setOnAttachStateChangeListener(new OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
                WindowInsets insets;
                if (Build.VERSION.SDK_INT >= 29 && (insets = BaseTransientBottomBar.this.view.getRootWindowInsets()) != null) {
                    BaseTransientBottomBar.this.extraBottomMarginGestureInset = insets.getMandatorySystemGestureInsets().bottom;
                    BaseTransientBottomBar.this.updateMargins();
                }
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                if (BaseTransientBottomBar.this.isShownOrQueued()) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseTransientBottomBar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (this.view.getParent() == null) {
            ViewGroup.LayoutParams lp = this.view.getLayoutParams();
            this.extraBottomMarginAnchorView = this.calculateBottomMarginForAnchorView();
            this.updateMargins();
            this.view.setVisibility(4);
            this.targetParent.addView((View)this.view);
        }
        if (ViewCompat.isLaidOut((View)this.view)) {
            this.showViewImpl();
            return;
        }
        this.view.setOnLayoutChangeListener(new OnLayoutChangeListener(){

            @Override
            public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                BaseTransientBottomBar.this.view.setOnLayoutChangeListener(null);
                BaseTransientBottomBar.this.showViewImpl();
            }
        });
    }

    private void showViewImpl() {
        if (this.shouldAnimate()) {
            this.animateViewIn();
        } else {
            this.view.setVisibility(0);
            this.onViewShown();
        }
    }

    private int getViewAbsoluteBottom() {
        int[] absoluteLocation = new int[2];
        this.view.getLocationOnScreen(absoluteLocation);
        return absoluteLocation[1] + this.view.getHeight();
    }

    @RequiresApi(value=17)
    private int getScreenHeight() {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    private int calculateBottomMarginForAnchorView() {
        if (this.anchorView == null) {
            return 0;
        }
        int[] anchorViewLocation = new int[2];
        this.anchorView.getLocationOnScreen(anchorViewLocation);
        int anchorViewAbsoluteYTop = anchorViewLocation[1];
        int[] targetParentLocation = new int[2];
        this.targetParent.getLocationOnScreen(targetParentLocation);
        int targetParentAbsoluteYBottom = targetParentLocation[1] + this.targetParent.getHeight();
        return targetParentAbsoluteYBottom - anchorViewAbsoluteYTop;
    }

    void animateViewIn() {
        this.view.post(new Runnable(){

            @Override
            public void run() {
                if (BaseTransientBottomBar.this.view == null) {
                    return;
                }
                BaseTransientBottomBar.this.view.setVisibility(0);
                if (BaseTransientBottomBar.this.view.getAnimationMode() == 1) {
                    BaseTransientBottomBar.this.startFadeInAnimation();
                } else {
                    BaseTransientBottomBar.this.startSlideInAnimation();
                }
            }
        });
    }

    private void animateViewOut(int event) {
        if (this.view.getAnimationMode() == 1) {
            this.startFadeOutAnimation(event);
        } else {
            this.startSlideOutAnimation(event);
        }
    }

    private void startFadeInAnimation() {
        ValueAnimator alphaAnimator = this.getAlphaAnimator(0.0f, 1.0f);
        ValueAnimator scaleAnimator = this.getScaleAnimator(0.8f, 1.0f);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{alphaAnimator, scaleAnimator});
        animatorSet.setDuration(150L);
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                BaseTransientBottomBar.this.onViewShown();
            }
        });
        animatorSet.start();
    }

    private void startFadeOutAnimation(final int event) {
        ValueAnimator animator = this.getAlphaAnimator(1.0f, 0.0f);
        animator.setDuration(75L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                BaseTransientBottomBar.this.onViewHidden(event);
            }
        });
        animator.start();
    }

    private ValueAnimator getAlphaAnimator(float ... alphaValues) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])alphaValues);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                BaseTransientBottomBar.this.view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        return animator;
    }

    private ValueAnimator getScaleAnimator(float ... scaleValues) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])scaleValues);
        animator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator valueAnimator) {
                float scale = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                BaseTransientBottomBar.this.view.setScaleX(scale);
                BaseTransientBottomBar.this.view.setScaleY(scale);
            }
        });
        return animator;
    }

    private void startSlideInAnimation() {
        final int translationYBottom = this.getTranslationYBottom();
        if (USE_OFFSET_API) {
            ViewCompat.offsetTopAndBottom((View)this.view, (int)translationYBottom);
        } else {
            this.view.setTranslationY(translationYBottom);
        }
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{translationYBottom, 0});
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BaseTransientBottomBar.this.contentViewCallback.animateContentIn(70, 180);
            }

            public void onAnimationEnd(Animator animator) {
                BaseTransientBottomBar.this.onViewShown();
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private int previousAnimatedIntValue;
            {
                this.previousAnimatedIntValue = translationYBottom;
            }

            public void onAnimationUpdate(@NonNull ValueAnimator animator) {
                int currentAnimatedIntValue = (Integer)animator.getAnimatedValue();
                if (USE_OFFSET_API) {
                    ViewCompat.offsetTopAndBottom((View)BaseTransientBottomBar.this.view, (int)(currentAnimatedIntValue - this.previousAnimatedIntValue));
                } else {
                    BaseTransientBottomBar.this.view.setTranslationY(currentAnimatedIntValue);
                }
                this.previousAnimatedIntValue = currentAnimatedIntValue;
            }
        });
        animator.start();
    }

    private void startSlideOutAnimation(final int event) {
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, this.getTranslationYBottom()});
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BaseTransientBottomBar.this.contentViewCallback.animateContentOut(0, 180);
            }

            public void onAnimationEnd(Animator animator) {
                BaseTransientBottomBar.this.onViewHidden(event);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private int previousAnimatedIntValue = 0;

            public void onAnimationUpdate(@NonNull ValueAnimator animator) {
                int currentAnimatedIntValue = (Integer)animator.getAnimatedValue();
                if (USE_OFFSET_API) {
                    ViewCompat.offsetTopAndBottom((View)BaseTransientBottomBar.this.view, (int)(currentAnimatedIntValue - this.previousAnimatedIntValue));
                } else {
                    BaseTransientBottomBar.this.view.setTranslationY(currentAnimatedIntValue);
                }
                this.previousAnimatedIntValue = currentAnimatedIntValue;
            }
        });
        animator.start();
    }

    private int getTranslationYBottom() {
        int translationY = this.view.getHeight();
        ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            translationY += ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return translationY;
    }

    final void hideView(int event) {
        if (this.shouldAnimate() && this.view.getVisibility() == 0) {
            this.animateViewOut(event);
        } else {
            this.onViewHidden(event);
        }
    }

    void onViewShown() {
        SnackbarManager.getInstance().onShown(this.managerCallback);
        if (this.callbacks != null) {
            int callbackCount = this.callbacks.size();
            for (int i = callbackCount - 1; i >= 0; --i) {
                this.callbacks.get(i).onShown(this);
            }
        }
    }

    void onViewHidden(int event) {
        ViewParent parent;
        SnackbarManager.getInstance().onDismissed(this.managerCallback);
        if (this.callbacks != null) {
            int callbackCount = this.callbacks.size();
            for (int i = callbackCount - 1; i >= 0; --i) {
                this.callbacks.get(i).onDismissed(this, event);
            }
        }
        if ((parent = this.view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.view);
        }
    }

    boolean shouldAnimate() {
        int feedbackFlags = 1;
        List serviceList = this.accessibilityManager.getEnabledAccessibilityServiceList(feedbackFlags);
        return serviceList != null && serviceList.isEmpty();
    }

    static {
        USE_OFFSET_API = Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19;
        TAG = BaseTransientBottomBar.class.getSimpleName();
        handler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(@NonNull Message message) {
                switch (message.what) {
                    case 0: {
                        ((BaseTransientBottomBar)message.obj).showView();
                        return true;
                    }
                    case 1: {
                        ((BaseTransientBottomBar)message.obj).hideView(message.arg1);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static class SnackbarBaseLayout
    extends FrameLayout {
        private static final View.OnTouchListener consumeAllTouchListener = new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        };
        private OnLayoutChangeListener onLayoutChangeListener;
        private OnAttachStateChangeListener onAttachStateChangeListener;
        private int animationMode;
        private ColorStateList backgroundTint;
        private PorterDuff.Mode backgroundTintMode;

        protected SnackbarBaseLayout(@NonNull Context context) {
            this(context, null);
        }

        protected SnackbarBaseLayout(@NonNull Context context, AttributeSet attrs) {
            super(context, attrs);
            context = this.getContext();
            this.setOnTouchListener(consumeAllTouchListener);
            this.setFocusable(true);
            if (this.getBackground() == null) {
                ViewCompat.setBackground((View)this, (Drawable)this.createThemedBackground());
            }
        }

        public void setBackground(@Nullable Drawable drawable) {
            this.setBackgroundDrawable(drawable);
        }

        public void setBackgroundDrawable(@Nullable Drawable drawable) {
            if (drawable != null && this.backgroundTint != null) {
                drawable = DrawableCompat.wrap((Drawable)drawable.mutate());
                DrawableCompat.setTintList((Drawable)drawable, (ColorStateList)this.backgroundTint);
                DrawableCompat.setTintMode((Drawable)drawable, (PorterDuff.Mode)this.backgroundTintMode);
            }
            super.setBackgroundDrawable(drawable);
        }

        public void setBackgroundTintList(@Nullable ColorStateList backgroundTint) {
            this.backgroundTint = backgroundTint;
            if (this.getBackground() != null) {
                Drawable wrappedBackground = DrawableCompat.wrap((Drawable)this.getBackground().mutate());
                DrawableCompat.setTintList((Drawable)wrappedBackground, (ColorStateList)backgroundTint);
                DrawableCompat.setTintMode((Drawable)wrappedBackground, (PorterDuff.Mode)this.backgroundTintMode);
                if (wrappedBackground != this.getBackground()) {
                    super.setBackgroundDrawable(wrappedBackground);
                }
            }
        }

        public void setBackgroundTintMode(@Nullable PorterDuff.Mode backgroundTintMode) {
            this.backgroundTintMode = backgroundTintMode;
            if (this.getBackground() != null) {
                Drawable wrappedBackground = DrawableCompat.wrap((Drawable)this.getBackground().mutate());
                DrawableCompat.setTintMode((Drawable)wrappedBackground, (PorterDuff.Mode)backgroundTintMode);
                if (wrappedBackground != this.getBackground()) {
                    super.setBackgroundDrawable(wrappedBackground);
                }
            }
        }

        public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
            this.setOnTouchListener(onClickListener != null ? null : consumeAllTouchListener);
            super.setOnClickListener(onClickListener);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.onLayoutChangeListener != null) {
                this.onLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.onAttachStateChangeListener != null) {
                this.onAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
            ViewCompat.requestApplyInsets((View)this);
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.onAttachStateChangeListener != null) {
                this.onAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.onLayoutChangeListener = onLayoutChangeListener;
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
            this.onAttachStateChangeListener = listener;
        }

        int getAnimationMode() {
            return this.animationMode;
        }

        void setAnimationMode(int animationMode) {
            this.animationMode = animationMode;
        }

        float getBackgroundOverlayColorAlpha() {
            return 1.0f;
        }

        float getActionTextColorAlpha() {
            return 1.0f;
        }

        @NonNull
        private Drawable createThemedBackground() {
            float cornerRadius = Styles.dpToPx(this.getContext(), 4.0f);
            GradientDrawable background = new GradientDrawable();
            background.setShape(0);
            background.setCornerRadius(cornerRadius);
            if (this.backgroundTint != null) {
                Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)background);
                DrawableCompat.setTintList((Drawable)wrappedDrawable, (ColorStateList)this.backgroundTint);
                return wrappedDrawable;
            }
            return DrawableCompat.wrap((Drawable)background);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=1L)
    public static @interface Duration {
    }

    @Deprecated
    public static interface ContentViewCallback
    extends net.aihelp.ui.widget.snackbar.ContentViewCallback {
    }

    public static abstract class BaseCallback<B> {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(B transientBottomBar, int event) {
        }

        public void onShown(B transientBottomBar) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface DismissEvent {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface AnimationMode {
    }
}

