/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.res.Resources;
import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.aihelp.utils.ResResolver;

public class DateFormatUtil {
    private static long[] goBackNDays(int nDays, long timestamp) {
        long[] results = new long[2];
        Calendar c = Calendar.getInstance();
        DateFormatUtil.clearCalendar(c, 11, 12, 13, 14);
        c.add(5, -nDays);
        results[0] = c.getTimeInMillis();
        c.setTimeInMillis(timestamp);
        DateFormatUtil.clearCalendar(c, 11, 12, 13, 14);
        results[1] = c.getTimeInMillis();
        return results;
    }

    private static void clearCalendar(Calendar c, int ... fields) {
        for (int f : fields) {
            c.set(f, 0);
        }
    }

    public static boolean isToday(long timeStamp) {
        long[] time = DateFormatUtil.goBackNDays(0, timeStamp);
        return time[0] == time[1];
    }

    public static boolean isYesterday(long timeStamp) {
        long[] time = DateFormatUtil.goBackNDays(1, timeStamp);
        return time[0] == time[1];
    }

    public static boolean isBackNDays(int n, long timeStamp) {
        long[] time = DateFormatUtil.goBackNDays(n, timeStamp);
        return time[0] <= time[1];
    }

    public static String getWeekOfDate(Resources resources, long timeStamp) {
        String[] weekDays = new String[]{ResResolver.getString("aihelp_sunday"), ResResolver.getString("aihelp_monday"), ResResolver.getString("aihelp_tuesday"), ResResolver.getString("aihelp_wednesday"), ResResolver.getString("aihelp_thursday"), ResResolver.getString("aihelp_friday"), ResResolver.getString("aihelp_saturday")};
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(timeStamp));
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String dateFormat(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static Date StringToDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = formatter.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String CSTFormat(String str) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Date date = formatter.parse(str);
        return DateFormatUtil.dateFormat(date);
    }

    public static Date LongToDare(long str) {
        return new Date(str);
    }

    public static String dateFormat(long timeStamp) {
        return DateFormatUtil.dateFormat(DateFormatUtil.LongToDare(timeStamp));
    }

    public static String dateFormat(String strDateFormat) {
        Date date = new Date();
        if (TextUtils.isEmpty((CharSequence)strDateFormat)) {
            strDateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        return sdf.format(date);
    }

    public static String getTodayTime(long timeStamp) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
        return formatter.format(new Date(timeStamp));
    }

    public static String getProperDate(Resources resources, long timeStamp) {
        if (DateFormatUtil.isToday(timeStamp)) {
            return DateFormatUtil.getTodayTime(timeStamp);
        }
        if (DateFormatUtil.isYesterday(timeStamp)) {
            return ResResolver.getString("aihelp_yesterday") + " " + DateFormatUtil.getTodayTime(timeStamp);
        }
        if (DateFormatUtil.isBackNDays(6, timeStamp)) {
            return DateFormatUtil.getWeekOfDate(resources, timeStamp) + " " + DateFormatUtil.getTodayTime(timeStamp);
        }
        return DateFormatUtil.dateFormat(timeStamp) + " " + DateFormatUtil.getTodayTime(timeStamp);
    }
}

