/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import java.util.Timer;
import java.util.TimerTask;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;

public enum DebounceHelper {
    INSTANCE;

    private Timer debounceTimer;

    public void debounceAsync(final Runnable runnable) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                DebounceHelper.this.debounce(runnable, 500);
            }
        });
    }

    public void debounce(Runnable runnable) {
        this.debounce(runnable, 500);
    }

    public void debounceAsync(final Runnable runnable, final int delay) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                DebounceHelper.this.debounce(runnable, delay);
            }
        });
    }

    public void debounce(final Runnable runnable, int delay) {
        this.resetTimer();
        this.debounceTimer = new Timer();
        this.debounceTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (DebounceHelper.this.debounceTimer != null && runnable != null) {
                    runnable.run();
                }
            }
        }, delay);
    }

    public void resetTimer() {
        if (this.debounceTimer != null) {
            this.debounceTimer.cancel();
        }
    }
}

