/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import androidx.annotation.RestrictTo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.init.PrivacyControlEntity;
import net.aihelp.utils.DeviceUuidFactory;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceInfoUtil {
    private Context context;
    private static DeviceInfoUtil sInstance;

    private DeviceInfoUtil(Context context) {
        if (context != null) {
            this.context = context.getApplicationContext();
        }
    }

    public static DeviceInfoUtil getInstance() {
        if (sInstance == null) {
            Context context = AIHelpContext.getInstance().getContext();
            sInstance = new DeviceInfoUtil(context.getApplicationContext());
        }
        return sInstance;
    }

    public int getStatusBarHeight() {
        int statusBarHeight = 0;
        int resourceId = this.context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    public String getSimCountryIso() {
        String simCountryIso;
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        if (tm != null && !TextUtils.isEmpty((CharSequence)(simCountryIso = tm.getSimCountryIso()))) {
            return simCountryIso.toUpperCase();
        }
        return Locale.getDefault().getCountry();
    }

    public String getTimeStamp() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH).format(new Date());
    }

    public String getAvailMemory() {
        ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return Formatter.formatFileSize((Context)this.context, (long)mi.availMem);
    }

    public String getTotalMemory() {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            String[] arrayOfString;
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            for (String num : arrayOfString = str2.split("\\s+")) {
                Log.i((String)str2, (String)(num + "\t"));
            }
            int i = Integer.parseInt(arrayOfString[1]);
            initial_memory = (long)i * 1024L;
            localBufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Formatter.formatFileSize((Context)this.context, (long)initial_memory);
    }

    public String getCarrierName() {
        TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
        return tm == null ? "" : tm.getNetworkOperatorName();
    }

    public String getNetworkType() {
        String type = "Unknown";
        try {
            NetworkInfo ani;
            ConnectivityManager cm = (ConnectivityManager)this.context.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (ani = cm.getActiveNetworkInfo()) != null) {
                type = ani.getTypeName();
            }
        }
        catch (SecurityException var4) {
            type = null;
        }
        return type;
    }

    public String getBatteryStatus() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, filter);
        if (batteryStatus == null) {
            return "Not charging";
        }
        int status = batteryStatus.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        return isCharging ? "Charging" : "Not charging";
    }

    public String getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, filter);
        if (batteryStatus == null) {
            return "";
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        int batteryPct = (int)((float)level / (float)scale * 100.0f);
        return batteryPct + "%";
    }

    public String getTotalDiskSpace() {
        double total_phone_memory;
        double bytesInOneGB = 1.073741824E9;
        StatFs phoneStat = new StatFs(Environment.getDataDirectory().getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            total_phone_memory = (double)phoneStat.getBlockCountLong() * (double)phoneStat.getBlockSizeLong() / bytesInOneGB;
            total_phone_memory = (double)Math.round(total_phone_memory * 100.0) / 100.0;
        } else {
            total_phone_memory = (double)phoneStat.getBlockCount() * (double)phoneStat.getBlockSize() / bytesInOneGB;
            total_phone_memory = (double)Math.round(total_phone_memory * 100.0) / 100.0;
        }
        return total_phone_memory + "GB";
    }

    public String getRemainDiskSpace() {
        double free_phone_memory;
        double bytesInOneGB = 1.073741824E9;
        StatFs phoneStat = new StatFs(Environment.getDataDirectory().getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            free_phone_memory = (double)phoneStat.getAvailableBlocksLong() * (double)phoneStat.getBlockSizeLong() / bytesInOneGB;
            free_phone_memory = (double)Math.round(free_phone_memory * 100.0) / 100.0;
        } else {
            free_phone_memory = (double)phoneStat.getAvailableBlocks() * (double)phoneStat.getBlockSize() / bytesInOneGB;
            free_phone_memory = (double)Math.round(free_phone_memory * 100.0) / 100.0;
        }
        return free_phone_memory + "GB";
    }

    private static JSONObject getHostGameInfo(PrivacyControlEntity entity) {
        String hostPackageName = "unknown";
        String hostAppVersion = "0.0.0";
        String hostApplicationName = "unknown";
        try {
            Context context = AIHelpContext.getInstance().getContext();
            hostPackageName = context.getPackageName();
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(hostPackageName, 0);
            hostAppVersion = context.getPackageManager().getPackageInfo((String)hostPackageName, (int)0).versionName;
            hostApplicationName = (String)context.getPackageManager().getApplicationLabel(ai);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        JSONObject params = new JSONObject();
        try {
            if (entity != null && entity.getApplicationIdentifier()) {
                params.put("Application_Identifier", (Object)hostPackageName);
            }
            if (entity != null && entity.getApplicationVersion()) {
                params.put("Application_Version", (Object)hostAppVersion);
            }
            if (entity != null && entity.getApplicationName()) {
                params.put("Name", (Object)hostApplicationName);
            }
            if (entity != null && entity.getServerId()) {
                params.put("ServerId", (Object)UserProfile.SERVER_ID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private JSONObject getHardwareInfo(PrivacyControlEntity entity) {
        JSONObject hardwareInfo = new JSONObject();
        try {
            hardwareInfo.put("DeviceId", (Object)DeviceUuidFactory.id(this.context));
            if (entity != null && entity.getTotalMemory()) {
                hardwareInfo.put("totalMemory", (Object)this.getTotalMemory());
            }
            if (entity != null && entity.getAvailableMemory()) {
                hardwareInfo.put("availableMemory", (Object)this.getAvailMemory());
            }
            if (entity != null && entity.getDeviceModel()) {
                hardwareInfo.put("Device_Model", (Object)String.format("%s %s", Build.MANUFACTURER, Build.MODEL));
            }
            if (entity != null && entity.getFreeSpacePhone()) {
                hardwareInfo.put("Free_Space", (Object)this.getRemainDiskSpace());
            }
            if (entity != null && entity.getTotalSpacePhone()) {
                hardwareInfo.put("Total_Space", (Object)this.getTotalDiskSpace());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hardwareInfo;
    }

    private JSONObject getOtherInfo(PrivacyControlEntity entity) {
        JSONObject otherInfo = new JSONObject();
        try {
            otherInfo.put("Platform", (Object)"android");
            otherInfo.put("Language", (Object)Const.ORIGINAL_LANGUAGE);
            otherInfo.put("SDK_Version", (Object)"4.6.0");
            if (entity != null && entity.getOsVersion()) {
                otherInfo.put("OS_Version", (Object)Build.VERSION.RELEASE);
            }
            if (entity != null && entity.getNetworkType()) {
                otherInfo.put("Network_Type", (Object)this.getNetworkType());
            }
            if (entity != null && entity.getOperator()) {
                otherInfo.put("Carrier", (Object)this.getCarrierName());
            }
            if (entity != null && entity.getCountryCode()) {
                otherInfo.put("Country_Code", (Object)this.getSimCountryIso());
            }
            if (!TextUtils.isEmpty((CharSequence)Const.PUSH_INFO) && Const.PUSH_INFO.contains("|")) {
                String pushToken = Const.PUSH_INFO.split("\\|")[0];
                int pushPlatform = Integer.parseInt(Const.PUSH_INFO.split("\\|")[1]);
                JSONObject pushInfo = JsonHelper.getJsonObject();
                pushInfo.put("Token", (Object)pushToken);
                pushInfo.put("PushTypeId", pushPlatform);
                otherInfo.put("PushToken", (Object)pushInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return otherInfo;
    }

    private String fillStoryNodeToCustomData() {
        if (TextUtils.isEmpty((CharSequence)UserProfile.ENTRANCE_TAGS)) {
            return UserProfile.CUSTOM_DATA;
        }
        try {
            JSONObject customData = new JSONObject(UserProfile.CUSTOM_DATA);
            JSONObject elvaMetaData = JsonHelper.getJsonObject(customData, "elva-custom-metadata");
            String originUserTags = JsonHelper.optString(elvaMetaData, "hs-tags");
            if (TextUtils.isEmpty((CharSequence)originUserTags)) {
                this.insertUserTagsIntoCustomData(elvaMetaData, UserProfile.ENTRANCE_TAGS);
            } else {
                this.insertUserTagsIntoCustomData(elvaMetaData, originUserTags + "," + UserProfile.ENTRANCE_TAGS);
            }
            JSONObject returnData = new JSONObject();
            returnData.put("elva-custom-metadata", (Object)elvaMetaData);
            returnData.put("hs-custom-metadata", (Object)new JSONObject(elvaMetaData.toString()));
            return returnData.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return UserProfile.CUSTOM_DATA;
        }
    }

    private void insertUserTagsIntoCustomData(JSONObject metaData, String userTags) {
        String[] userTagsArray = userTags.split(",");
        if (userTagsArray.length > 0) {
            try {
                metaData.put("elva-tags", Arrays.asList(userTagsArray));
                metaData.put("hs-tags", (Object)userTags);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getProxyConfiguration() {
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (!TextUtils.isEmpty((CharSequence)host) || !TextUtils.isEmpty((CharSequence)port)) {
            return host + ":" + port;
        }
        return "";
    }

    public JSONObject getGameInfo() {
        JSONObject gameInfo = new JSONObject();
        try {
            PrivacyControlEntity entity = CustomConfig.InitSetting.privacyControlData;
            gameInfo.put("APPLICATION", (Object)DeviceInfoUtil.getHostGameInfo(entity));
            gameInfo.put("HARDWARE", (Object)this.getHardwareInfo(entity));
            gameInfo.put("OTHER", (Object)this.getOtherInfo(entity));
            gameInfo.put("CUSTOMDATA", (Object)this.fillStoryNodeToCustomData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gameInfo;
    }

    public String getDeviceIdFromCustomData() {
        try {
            JSONObject customData = new JSONObject(UserProfile.CUSTOM_DATA);
            JSONObject elvaMetaData = JsonHelper.getJsonObject(customData, "elva-custom-metadata");
            return elvaMetaData.optString("deviceId");
        }
        catch (Exception e) {
            return "";
        }
    }
}

