/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.SpUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceUuidFactory {
    private static String sID = null;
    private static final String INSTALLATION = "INSTALLATION";

    public static synchronized String id(Context context) {
        if (context == null && (context = AIHelpContext.getInstance().getContext()) == null) {
            sID = UUID.randomUUID().toString().trim();
            return sID;
        }
        if (sID == null) {
            String deviceIdOf1x = SpUtil.getInstance().get1_xDeviceId();
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (installation.exists()) {
                    sID = DeviceUuidFactory.readInstallationFile(installation);
                } else if (!TextUtils.isEmpty((CharSequence)deviceIdOf1x)) {
                    sID = deviceIdOf1x.trim();
                } else {
                    DeviceUuidFactory.writeInstallationFile(installation);
                    sID = DeviceUuidFactory.readInstallationFile(installation);
                }
            }
            catch (Exception e) {
                sID = "" + UUID.randomUUID().toString().trim();
                return sID;
            }
        }
        return sID;
    }

    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int)f.length()];
        f.readFully(bytes);
        f.close();
        return new String(bytes).trim();
    }

    private static void writeInstallationFile(File installation) throws IOException {
        FileOutputStream out = new FileOutputStream(installation);
        String id2 = UUID.randomUUID().toString().trim();
        out.write(id2.getBytes());
        out.close();
    }
}

