/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.utils.RegexUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

public class DownloadHelper {
    public static void save(final Context context, String path, final OnDownloadProgressChangedListener listener) {
        final String fileName = DownloadHelper.getSplitFileName(path);
        final String savePath = DownloadHelper.getTargetSavePath(path, fileName);
        AIHelpRequest.getInstance().requestDownloadFile(path, savePath, new ReqCallback<String>(){

            @Override
            public void onReqProgress(long totalContentLength, long currentTransferred, int progress) {
                if (listener != null) {
                    listener.onProgressChanged(progress);
                }
            }

            @Override
            public void onReqSuccess(String result) {
                try {
                    if (RegexUtil.isVideoFile(savePath)) {
                        DownloadHelper.insertVideo(context, savePath);
                    } else if (RegexUtil.isGifFile(savePath)) {
                        DownloadHelper.insertGif(context, savePath);
                    } else {
                        DownloadHelper.insertImage(context, savePath, fileName);
                    }
                    if (!RegexUtil.isVideoFile(savePath)) {
                        ToastUtil.INSTANCE.makeTextWithIcon(context, ResResolver.getString("aihelp_save_seccessfully"), false);
                    }
                }
                catch (Exception e) {
                    String saveFailedToastMessage = String.format("%s: %s", ResResolver.getString("aihelp_save_seccessfully"), savePath);
                    ToastUtil.INSTANCE.makeRawToast(context, saveFailedToastMessage);
                }
            }
        });
    }

    private static void insertVideo(Context context, String filePath) {
        ContentResolver resolver = context.getContentResolver();
        Uri collectionUri = Build.VERSION.SDK_INT >= 29 ? MediaStore.Video.Media.getContentUri((String)"external_primary") : MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        ContentValues values = new ContentValues();
        values.put("_display_name", DownloadHelper.getSplitFileName(filePath));
        values.put("mime_type", DownloadHelper.getMIMEType(filePath));
        values.put("date_added", Long.valueOf(System.currentTimeMillis()));
        values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        Uri itemUri = resolver.insert(collectionUri, values);
        try (FileInputStream inputStream = new FileInputStream(filePath);
             OutputStream outputStream = resolver.openOutputStream(itemUri);){
            int n;
            byte[] buf = new byte[8192];
            while ((n = ((InputStream)inputStream).read(buf)) > 0) {
                outputStream.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertGif(Context context, String filePath) {
        ContentResolver resolver = context.getContentResolver();
        Uri collectionUri = Build.VERSION.SDK_INT >= 29 ? MediaStore.Images.Media.getContentUri((String)"external_primary") : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentValues values = new ContentValues();
        values.put("_display_name", DownloadHelper.getSplitFileName(filePath));
        values.put("mime_type", "image/gif");
        values.put("date_added", Long.valueOf(System.currentTimeMillis()));
        values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        Uri itemUri = resolver.insert(collectionUri, values);
        try (FileInputStream inputStream = new FileInputStream(filePath);
             OutputStream outputStream = resolver.openOutputStream(itemUri);){
            int n;
            byte[] buf = new byte[8192];
            while ((n = ((InputStream)inputStream).read(buf)) > 0) {
                outputStream.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertImage(Context context, String filePath, String fileName) throws FileNotFoundException {
        File file = new File(filePath);
        MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)filePath, (String)fileName, null);
        if (Build.VERSION.SDK_INT < 19) {
            Intent intent = new Intent("android.intent.action.MEDIA_MOUNTED", Uri.fromFile((File)file));
            intent.addFlags(2);
            context.sendBroadcast(intent);
        } else {
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file));
            intent.addFlags(2);
            context.sendBroadcast(intent);
        }
    }

    private static String getMIMEType(String filePath) {
        try {
            String fileExtension = "mp4";
            int i = filePath.lastIndexOf(46);
            if (i > 0) {
                fileExtension = filePath.substring(i + 1);
            }
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension);
        }
        catch (Exception e) {
            return "video/mp4";
        }
    }

    private static String getSplitFileName(String filePath) {
        String[] split;
        if (!TextUtils.isEmpty((CharSequence)filePath) && (split = filePath.split("/")).length > 0) {
            return "AIHelp-" + split[split.length - 1];
        }
        return "UnknownFile";
    }

    public static String getTargetSavePath(String filePath, String fileName) {
        File dirFile;
        String dirPath = "";
        File filesDir = AIHelpContext.getInstance().getContext().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        if (filesDir != null && !(dirFile = new File(dirPath = filesDir.getAbsolutePath() + "/AIHelp")).exists() && dirFile.mkdirs()) {
            return dirFile.getAbsolutePath() + File.separator + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    public static interface OnDownloadProgressChangedListener {
        public void onProgressChanged(int var1);
    }
}

