/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.utils;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FileUtil {
    private static final HashSet<String> imageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"));
    private static final Set<String> resizableImageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/x-png", "image/x-citrix-pjpeg", "image/pjpeg"));

    public static boolean isSupportedMimeType(String mimeType) {
        return imageMimeTypes.contains(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(URL url, File saveFile) {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = url.openStream();
            output = new FileOutputStream(saveFile);
            byte[] buffer = new byte[500];
            while ((bytesRead = input.read(buffer, 0, buffer.length)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(input);
                FileUtil.closeQuietly(output);
                throw throwable;
            }
            FileUtil.closeQuietly(input);
            FileUtil.closeQuietly(output);
        }
        FileUtil.closeQuietly(input);
        FileUtil.closeQuietly(output);
    }

    private static void closeQuietly(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMimeType(URL url) {
        try {
            return url.openConnection().getContentType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMimeType(String fileLocation) {
        try {
            return FileUtil.getMimeType(new URL("file://" + fileLocation));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileFromUriExistAndCanRead(Uri uri, Context context) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            boolean bl = parcelFileDescriptor != null;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            TLog.d("doesFileFromUriExistAndCanRead exception " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized String getContentFromFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                RandomAccessFile f = new RandomAccessFile(file, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                f.close();
                return new String(bytes);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean writeFileToDisk(InputStream ins, String filePath) {
        Context context = AIHelpContext.getInstance().getContext();
        try {
            if (context == null) return false;
            File targetFile = new File(filePath);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                byte[] fileReader = new byte[8192];
                inputStream = ins;
                outputStream = new FileOutputStream(targetFile);
                while (true) {
                    int read;
                    if ((read = inputStream.read(fileReader)) == -1) {
                        outputStream.flush();
                        boolean bl = true;
                        return bl;
                    }
                    outputStream.write(fileReader, 0, read);
                }
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return false;
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static File copyAndRenameFile(Context context, String sourcePath, String newFileName) {
        File sourceFile;
        if (!TextUtils.isEmpty((CharSequence)sourcePath) && (sourceFile = new File(sourcePath)).exists() && sourceFile.length() > 0L) {
            String destinationFolder = context.getFilesDir().getAbsolutePath() + "/AIHelp/event";
            File destinationFile = new File(destinationFolder, newFileName);
            if (destinationFile.exists()) {
                destinationFile.delete();
            }
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                File file;
                try (FileOutputStream fos = new FileOutputStream(destinationFile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = fis.read(buffer)) > 0) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    file = destinationFile;
                }
                return file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

